/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.gradle.cache.Cache;
import org.gradle.internal.Try;
import org.gradle.internal.execution.DeferredExecutionHandler;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.steps.DeferredExecutionAwareStep;
import org.gradle.internal.execution.steps.ExecutionRequestContext;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.ValueSnapshot;

public class IdentifyStep<C extends ExecutionRequestContext, R extends Result>
implements DeferredExecutionAwareStep<C, R> {
    private final DeferredExecutionAwareStep<? super IdentityContext, R> delegate;
    private final InputFingerprinter inputFingerprinter;

    public IdentifyStep(InputFingerprinter inputFingerprinter, DeferredExecutionAwareStep<? super IdentityContext, R> delegate) {
        this.inputFingerprinter = inputFingerprinter;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        return this.delegate.execute(work, this.createIdentityContext(work, context));
    }

    @Override
    public <T, O> T executeDeferred(UnitOfWork work, C context, Cache<UnitOfWork.Identity, Try<O>> cache2, DeferredExecutionHandler<O, T> handler) {
        return this.delegate.executeDeferred(work, this.createIdentityContext(work, context), cache2, handler);
    }

    @Nonnull
    private IdentityContext createIdentityContext(UnitOfWork work, C context) {
        InputFingerprinter.Result inputs = this.inputFingerprinter.fingerprintInputProperties(work, ImmutableSortedMap.of(), ImmutableSortedMap.of(), ImmutableSortedMap.of(), (propertyName, type, identity) -> identity == UnitOfWork.IdentityKind.IDENTITY);
        ImmutableSortedMap<String, ValueSnapshot> identityInputProperties = inputs.getValueSnapshots();
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> identityInputFileProperties = inputs.getFileFingerprints();
        UnitOfWork.Identity identity2 = work.identify(identityInputProperties, identityInputFileProperties);
        return new IdentityContext((ExecutionRequestContext)context, identityInputProperties, identityInputFileProperties, identity2){
            final /* synthetic */ ExecutionRequestContext val$context;
            final /* synthetic */ ImmutableSortedMap val$identityInputProperties;
            final /* synthetic */ ImmutableSortedMap val$identityInputFileProperties;
            final /* synthetic */ UnitOfWork.Identity val$identity;
            {
                this.val$context = executionRequestContext;
                this.val$identityInputProperties = immutableSortedMap;
                this.val$identityInputFileProperties = immutableSortedMap2;
                this.val$identity = identity;
            }

            @Override
            public Optional<String> getRebuildReason() {
                return this.val$context.getRebuildReason();
            }

            @Override
            public WorkValidationContext getValidationContext() {
                return this.val$context.getValidationContext();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return this.val$identityInputProperties;
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return this.val$identityInputFileProperties;
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return this.val$identity;
            }
        };
    }
}

