/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import org.gradle.cache.Cache;
import org.gradle.internal.Cast;
import org.gradle.internal.Try;
import org.gradle.internal.execution.DeferredExecutionHandler;
import org.gradle.internal.execution.ExecutionResult;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.DeferredExecutionAwareStep;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;

public class IdentityCacheStep<C extends IdentityContext, R extends Result>
implements DeferredExecutionAwareStep<C, R> {
    private final Step<? super IdentityContext, ? extends R> delegate;

    public IdentityCacheStep(Step<? super IdentityContext, ? extends R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        return this.delegate.execute(work, (IdentityContext)context);
    }

    @Override
    public <T, O> T executeDeferred(UnitOfWork work, C context, Cache<UnitOfWork.Identity, Try<O>> cache2, DeferredExecutionHandler<O, T> handler) {
        UnitOfWork.Identity identity = context.getIdentity();
        Try<O> cachedOutput = cache2.getIfPresent(identity);
        if (cachedOutput != null) {
            return handler.processCachedOutput(cachedOutput);
        }
        return handler.processDeferredOutput(() -> cache2.get(identity, () -> this.execute(work, context).getExecutionResult().map(ExecutionResult::getOutput).map(Cast::uncheckedNonnullCast)));
    }
}

