/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.steps.AfterPreviousExecutionContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.ValidationContext;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.model.internal.type.ModelType;
import org.gradle.problems.BaseProblem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateStep<R extends Result>
implements Step<AfterPreviousExecutionContext, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateStep.class);
    private static final String MAX_NB_OF_ERRORS = "org.gradle.internal.max.validation.errors";
    private final VirtualFileSystem virtualFileSystem;
    private final ValidationWarningRecorder warningReporter;
    private final Step<? super ValidationContext, ? extends R> delegate;

    public ValidateStep(VirtualFileSystem virtualFileSystem, ValidationWarningRecorder warningReporter, Step<? super ValidationContext, ? extends R> delegate) {
        this.virtualFileSystem = virtualFileSystem;
        this.warningReporter = warningReporter;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, final AfterPreviousExecutionContext context) {
        WorkValidationContext validationContext = context.getValidationContext();
        work.validate(validationContext);
        Map problems = validationContext.getProblems().stream().collect(Collectors.groupingBy(BaseProblem::getSeverity, Collectors.mapping(ValidateStep::renderedMessage, Collectors.toList())));
        final ImmutableList<String> warnings = ImmutableList.copyOf(problems.getOrDefault((Object)Severity.WARNING, ImmutableList.of()));
        ImmutableList errors = ImmutableList.copyOf(problems.getOrDefault((Object)Severity.ERROR, ImmutableList.of()));
        if (!warnings.isEmpty()) {
            this.warningReporter.recordValidationWarnings(work, warnings);
        }
        if (!errors.isEmpty()) {
            int maxErrCount = Integer.getInteger(MAX_NB_OF_ERRORS, 5);
            ImmutableSortedSet<String> uniqueSortedErrors = ImmutableSortedSet.copyOf(errors);
            throw WorkValidationException.forProblems(uniqueSortedErrors).limitTo(maxErrCount).withSummary(helper -> String.format("%s found with the configuration of %s (%s).", helper.size() == 1 ? "A problem was" : "Some problems were", work.getDisplayName(), ValidateStep.describeTypesChecked(validationContext.getValidatedTypes()))).get();
        }
        if (!warnings.isEmpty()) {
            LOGGER.info("Invalidating VFS because {} failed validation", (Object)work.getDisplayName());
            this.virtualFileSystem.invalidateAll();
        }
        return this.delegate.execute(work, new ValidationContext(){

            @Override
            public Optional<ValidationContext.ValidationResult> getValidationProblems() {
                return warnings.isEmpty() ? Optional.empty() : Optional.of(() -> warnings);
            }

            @Override
            public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                return context.getAfterPreviousExecutionState();
            }

            @Override
            public File getWorkspace() {
                return context.getWorkspace();
            }

            @Override
            public Optional<ExecutionHistoryStore> getHistory() {
                return context.getHistory();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return context.getInputProperties();
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return context.getInputFileProperties();
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return context.getIdentity();
            }

            @Override
            public Optional<String> getRebuildReason() {
                return context.getRebuildReason();
            }

            @Override
            public WorkValidationContext getValidationContext() {
                return context.getValidationContext();
            }
        });
    }

    private static String renderedMessage(TypeValidationProblem p) {
        if (((Severity)((Object)p.getSeverity())).isWarning()) {
            return TypeValidationProblemRenderer.convertToSingleLine(TypeValidationProblemRenderer.renderMinimalInformationAbout(p, true, false));
        }
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(p);
    }

    private static String describeTypesChecked(ImmutableCollection<Class<?>> types) {
        return types.size() == 1 ? "type '" + ValidateStep.getTypeDisplayName((Class)types.iterator().next()) + "'" : "types '" + types.stream().map(ValidateStep::getTypeDisplayName).collect(Collectors.joining("', '")) + "'";
    }

    private static String getTypeDisplayName(Class<?> type) {
        return ModelType.of(type).getDisplayName();
    }

    public static interface ValidationWarningRecorder {
        public void recordValidationWarnings(UnitOfWork var1, Collection<String> var2);
    }
}

