/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.timeout.impl;

import java.io.PrintWriter;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.internal.concurrent.ManagedScheduledExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.execution.timeout.Timeout;
import org.gradle.internal.execution.timeout.TimeoutHandler;
import org.gradle.internal.impldep.com.google.common.io.CharStreams;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.TimeFormatting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTimeoutHandler
implements TimeoutHandler,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTimeoutHandler.class);
    public static final String POST_TIMEOUT_CHECK_FREQUENCY_PROPERTY = DefaultTimeoutHandler.class.getName() + ".postTimeoutCheckFrequency";
    public static final String SLOW_STOP_LOG_STACKTRACE_FREQUENCY_PROPERTY = DefaultTimeoutHandler.class.getName() + ".slowStopLogStacktraceFrequency";
    private final ManagedScheduledExecutor executor;
    private final CurrentBuildOperationRef currentBuildOperationRef;

    public DefaultTimeoutHandler(ManagedScheduledExecutor executor, CurrentBuildOperationRef currentBuildOperationRef) {
        this.executor = executor;
        this.currentBuildOperationRef = currentBuildOperationRef;
    }

    @Override
    public Timeout start(Thread taskExecutionThread, Duration timeout, Describable workUnitDescription, @Nullable BuildOperationRef buildOperationRef) {
        return new DefaultTimeout(taskExecutionThread, timeout, workUnitDescription, buildOperationRef);
    }

    @Override
    public void stop() {
        this.executor.stop();
    }

    private static long postTimeoutCheckFrequency() {
        return Integer.parseInt(System.getProperty(POST_TIMEOUT_CHECK_FREQUENCY_PROPERTY, "3000"));
    }

    private static long slowStopLogStacktraceFrequency() {
        return Integer.parseInt(System.getProperty(SLOW_STOP_LOG_STACKTRACE_FREQUENCY_PROPERTY, "10000"));
    }

    private final class DefaultTimeout
    implements Timeout {
        private final Thread thread;
        private final Duration timeout;
        private final Describable workUnitDescription;
        @Nullable
        private final BuildOperationRef buildOperationRef;
        private final Object lock = new Object();
        private boolean slowStop;
        private boolean stopped;
        private boolean interrupted;
        private StackTraceElement[] lastStacktrace;
        private CountdownTimer logStacktraceTimer;
        private ScheduledFuture<?> scheduledFuture;

        private DefaultTimeout(Thread thread, Duration timeout, @Nullable Describable workUnitDescription, BuildOperationRef buildOperationRef) {
            this.thread = thread;
            this.timeout = timeout;
            this.workUnitDescription = workUnitDescription;
            this.buildOperationRef = buildOperationRef;
            this.scheduledFuture = DefaultTimeoutHandler.this.executor.schedule(this::onTimeout, timeout.toMillis(), TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onTimeout() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.stopped) {
                    this.interrupted = true;
                    this.doAsPartOfBuildOperation(() -> LOGGER.warn("Requesting stop of {} as it has exceeded its configured timeout of {}.", (Object)this.workUnitDescription.getDisplayName(), (Object)TimeFormatting.formatDurationTerse(this.timeout.toMillis())));
                    this.thread.interrupt();
                    this.logStacktraceTimer = Time.startCountdownTimer(DefaultTimeoutHandler.slowStopLogStacktraceFrequency());
                    this.scheduledFuture = DefaultTimeoutHandler.this.executor.schedule(this::onAfterTimeoutCheck, DefaultTimeoutHandler.postTimeoutCheckFrequency(), TimeUnit.MILLISECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAfterTimeoutCheck() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.stopped) {
                    this.slowStop = true;
                    this.doAsPartOfBuildOperation(() -> {
                        LOGGER.warn("Timed out {} has not yet stopped.", (Object)this.workUnitDescription.getDisplayName());
                        if (this.logStacktraceTimer.hasExpired()) {
                            Object[] currentStackTrace = this.thread.getStackTrace();
                            if (currentStackTrace.length > 0 && !Arrays.equals(this.lastStacktrace, currentStackTrace)) {
                                this.lastStacktrace = currentStackTrace;
                                this.logStacktrace((StackTraceElement[])currentStackTrace);
                            }
                            this.logStacktraceTimer.reset();
                        }
                    });
                    this.thread.interrupt();
                    this.scheduledFuture = DefaultTimeoutHandler.this.executor.schedule(this::onAfterTimeoutCheck, DefaultTimeoutHandler.postTimeoutCheckFrequency(), TimeUnit.MILLISECONDS);
                }
            }
        }

        private void logStacktrace(StackTraceElement[] currentStackTrace) {
            if (LOGGER.isWarnEnabled()) {
                StringBuilder logMessageBuilder = new StringBuilder();
                try (PrintWriter logMessageWriter = new PrintWriter(CharStreams.asWriter(logMessageBuilder));){
                    logMessageWriter.print("Current stacktrace of timed out but not yet stopped ");
                    logMessageWriter.print(this.workUnitDescription.getDisplayName());
                    logMessageWriter.println(":");
                    for (StackTraceElement traceElement : currentStackTrace) {
                        logMessageWriter.println("  at " + traceElement);
                    }
                }
                LOGGER.warn(logMessageBuilder.toString());
            }
        }

        private void doAsPartOfBuildOperation(Runnable runnable) {
            BuildOperationRef previousBuildOperationRef = DefaultTimeoutHandler.this.currentBuildOperationRef.get();
            try {
                DefaultTimeoutHandler.this.currentBuildOperationRef.set(this.buildOperationRef);
                runnable.run();
            }
            finally {
                DefaultTimeoutHandler.this.currentBuildOperationRef.set(previousBuildOperationRef);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean stop() {
            Object object = this.lock;
            synchronized (object) {
                this.scheduledFuture.cancel(true);
                this.stopped = true;
                if (this.slowStop) {
                    LOGGER.warn("Timed out {} has stopped.", (Object)this.workUnitDescription.getDisplayName());
                }
                return this.interrupted;
            }
        }
    }
}

