/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.workspace.impl;

import java.io.Closeable;
import java.io.File;
import java.util.function.Function;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.impl.DefaultExecutionHistoryStore;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;

public class DefaultImmutableWorkspaceProvider
implements WorkspaceProvider,
Closeable {
    private static final int DEFAULT_FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final SingleDepthFileAccessTracker fileAccessTracker;
    private final File baseDirectory;
    private final ExecutionHistoryStore executionHistoryStore;
    private final PersistentCache cache;

    public static DefaultImmutableWorkspaceProvider withBuiltInHistory(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, StringInterner stringInterner) {
        return DefaultImmutableWorkspaceProvider.withBuiltInHistory(cacheBuilder, fileAccessTimeJournal, inMemoryCacheDecoratorFactory, stringInterner, 1);
    }

    public static DefaultImmutableWorkspaceProvider withBuiltInHistory(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, StringInterner stringInterner, int treeDepthToTrackAndCleanup) {
        return new DefaultImmutableWorkspaceProvider(cacheBuilder, fileAccessTimeJournal, cache2 -> new DefaultExecutionHistoryStore(() -> cache2, inMemoryCacheDecoratorFactory, stringInterner), treeDepthToTrackAndCleanup);
    }

    public static DefaultImmutableWorkspaceProvider withExternalHistory(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, ExecutionHistoryStore executionHistoryStore) {
        return new DefaultImmutableWorkspaceProvider(cacheBuilder, fileAccessTimeJournal, __ -> executionHistoryStore, 1);
    }

    private DefaultImmutableWorkspaceProvider(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, Function<PersistentCache, ExecutionHistoryStore> historyFactory, int treeDepthToTrackAndCleanup) {
        PersistentCache cache2;
        this.cache = cache2 = cacheBuilder.withCleanup(DefaultImmutableWorkspaceProvider.createCleanupAction(fileAccessTimeJournal, treeDepthToTrackAndCleanup)).withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.OnDemand)).open();
        this.baseDirectory = cache2.getBaseDir();
        this.fileAccessTracker = new SingleDepthFileAccessTracker(fileAccessTimeJournal, this.baseDirectory, treeDepthToTrackAndCleanup);
        this.executionHistoryStore = historyFactory.apply(cache2);
    }

    private static CleanupAction createCleanupAction(FileAccessTimeJournal fileAccessTimeJournal, int treeDepthToTrackAndCleanup) {
        return new LeastRecentlyUsedCacheCleanup(new SingleDepthFilesFinder(treeDepthToTrackAndCleanup), fileAccessTimeJournal, 7L);
    }

    @Override
    public <T> T withWorkspace(String path, WorkspaceProvider.WorkspaceAction<T> action) {
        return (T)this.cache.withFileLock(() -> {
            File workspace = new File(this.baseDirectory, path);
            this.fileAccessTracker.markAccessed(workspace);
            return action.executeInWorkspace(workspace, this.executionHistoryStore);
        });
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

