/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.Collection;
import java.util.Map;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.FileNormalizationSpec;
import org.gradle.internal.fingerprint.impl.DefaultFileNormalizationSpec;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class DefaultFileCollectionFingerprinterRegistry
implements FileCollectionFingerprinterRegistry {
    private final Map<FileNormalizationSpec, FileCollectionFingerprinter> fingerprinters;

    public DefaultFileCollectionFingerprinterRegistry(Collection<FileCollectionFingerprinter> fingerprinters) {
        this.fingerprinters = ImmutableMap.copyOf(Maps.uniqueIndex(fingerprinters, input -> DefaultFileNormalizationSpec.from(input.getRegisteredType(), input.getDirectorySensitivity())));
    }

    @Override
    public FileCollectionFingerprinter getFingerprinter(FileNormalizationSpec spec) {
        FileCollectionFingerprinter fingerprinter = this.fingerprinters.get(spec);
        if (fingerprinter == null) {
            throw new IllegalStateException(String.format("No fingerprinter registered with type '%s' and directory sensitivity '%s'", spec.getNormalizer().getName(), spec.getDirectorySensitivity().name()));
        }
        return fingerprinter;
    }

    @Override
    public FileCollectionFingerprinter getFingerprinter(InputFilePropertySpec spec) {
        return this.getFingerprinter(DefaultFileNormalizationSpec.from(spec.getNormalizer(), spec.getDirectorySensitivity()));
    }
}

