/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.gradle.api.Describable;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.Stat;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.util.GFileUtils;

public class PatternSetSnapshottingFilter
implements SnapshottingFilter {
    private final PatternSet patternSet;
    private final Stat stat;

    public PatternSetSnapshottingFilter(PatternSet patternSet, Stat stat) {
        this.stat = stat;
        this.patternSet = patternSet;
    }

    @Override
    public boolean isEmpty() {
        return this.patternSet.isEmpty();
    }

    @Override
    public SnapshottingFilter.FileSystemSnapshotPredicate getAsSnapshotPredicate() {
        Spec<FileTreeElement> spec = this.patternSet.getAsSpec();
        return (snapshot, relativePath) -> spec.isSatisfiedBy(new LogicalFileTreeElement(snapshot, relativePath, this.stat));
    }

    @Override
    public SnapshottingFilter.DirectoryWalkerPredicate getAsDirectoryWalkerPredicate() {
        Spec<FileTreeElement> spec = this.patternSet.getAsSpec();
        return (path, name, isDirectory, relativePath) -> spec.isSatisfiedBy(new PathBackedFileTreeElement(path, name, isDirectory, relativePath, this.stat));
    }

    private static class PathBackedFileTreeElement
    implements FileTreeElement {
        private final Path path;
        private final String name;
        private final boolean isDirectory;
        private final Iterable<String> relativePath;
        private final Stat stat;

        public PathBackedFileTreeElement(Path path, String name, boolean isDirectory, Iterable<String> relativePath, Stat stat) {
            this.path = path;
            this.name = name;
            this.isDirectory = isDirectory;
            this.relativePath = relativePath;
            this.stat = stat;
        }

        @Override
        public File getFile() {
            return this.path.toFile();
        }

        @Override
        public boolean isDirectory() {
            return this.isDirectory;
        }

        @Override
        public long getLastModified() {
            return this.getFile().lastModified();
        }

        @Override
        public long getSize() {
            return this.getFile().length();
        }

        @Override
        public InputStream open() {
            try {
                return Files.newInputStream(this.path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        @Override
        public void copyTo(OutputStream output) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        @Override
        public boolean copyTo(File target) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.getRelativePath().getPathString();
        }

        @Override
        public RelativePath getRelativePath() {
            return new RelativePath(!this.isDirectory, Iterables.toArray(this.relativePath, String.class));
        }

        @Override
        public int getMode() {
            return this.stat.getUnixMode(this.path.toFile());
        }
    }

    private static class LogicalFileTreeElement
    implements FileTreeElement,
    Describable {
        private final Iterable<String> relativePathIterable;
        private final Stat stat;
        private final FileSystemLocationSnapshot snapshot;
        private RelativePath relativePath;
        private File file;

        public LogicalFileTreeElement(FileSystemLocationSnapshot snapshot, Iterable<String> relativePathIterable, Stat stat) {
            this.snapshot = snapshot;
            this.relativePathIterable = relativePathIterable;
            this.stat = stat;
        }

        @Override
        public String getDisplayName() {
            return "file '" + this.getFile() + "'";
        }

        @Override
        public File getFile() {
            if (this.file == null) {
                this.file = new File(this.snapshot.getAbsolutePath());
            }
            return this.file;
        }

        @Override
        public boolean isDirectory() {
            return this.snapshot.getType() == FileType.Directory;
        }

        @Override
        public long getLastModified() {
            return this.getFile().lastModified();
        }

        @Override
        public long getSize() {
            return this.getFile().length();
        }

        @Override
        public InputStream open() {
            return GFileUtils.openInputStream(this.getFile());
        }

        @Override
        public void copyTo(OutputStream output) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        @Override
        public boolean copyTo(File target) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        @Override
        public String getName() {
            return this.getRelativePath().getLastName();
        }

        @Override
        public String getPath() {
            return this.getRelativePath().getPathString();
        }

        @Override
        public RelativePath getRelativePath() {
            if (this.relativePath == null) {
                this.relativePath = new RelativePath(!this.isDirectory(), Iterables.toArray(this.relativePathIterable, String.class));
            }
            return this.relativePath;
        }

        @Override
        public int getMode() {
            return this.stat.getUnixMode(this.getFile());
        }
    }
}

