/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.model;

import java.io.Serializable;
import java.util.Map;
import org.gradle.internal.impldep.com.amazonaws.AmazonServiceException;

public class AmazonS3Exception
extends AmazonServiceException
implements Serializable {
    private static final long serialVersionUID = 7573680383273658477L;
    private String extendedRequestId;
    private String cloudFrontId;
    private Map<String, String> additionalDetails;
    private final String errorResponseXml;

    public AmazonS3Exception(String message2) {
        super(message2);
        this.errorResponseXml = null;
    }

    public AmazonS3Exception(String message2, Exception cause) {
        super(message2, cause);
        this.errorResponseXml = null;
    }

    public AmazonS3Exception(String message2, String errorResponseXml) {
        super(message2);
        if (errorResponseXml == null) {
            throw new IllegalArgumentException("Error Response XML cannot be null");
        }
        this.errorResponseXml = errorResponseXml;
    }

    public String getExtendedRequestId() {
        return this.extendedRequestId;
    }

    public void setExtendedRequestId(String extendedRequestId) {
        this.extendedRequestId = extendedRequestId;
    }

    public String getCloudFrontId() {
        return this.cloudFrontId;
    }

    public void setCloudFrontId(String cloudFrontId) {
        this.cloudFrontId = cloudFrontId;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(Map<String, String> additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @Override
    public String toString() {
        return super.toString() + ", S3 Extended Request ID: " + this.getExtendedRequestId();
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage() + " (Service: " + this.getServiceName() + "; Status Code: " + this.getStatusCode() + "; Error Code: " + this.getErrorCode() + "; Request ID: " + this.getRequestId() + "; S3 Extended Request ID: " + this.getExtendedRequestId() + "; Proxy: " + this.getProxyHost() + ")";
    }

    public String getErrorResponseXml() {
        return this.errorResponseXml;
    }
}

