/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.api.client.googleapis.auth.clientlogin;

import java.io.IOException;
import org.gradle.internal.impldep.com.google.api.client.googleapis.auth.clientlogin.AuthKeyValueParser;
import org.gradle.internal.impldep.com.google.api.client.googleapis.auth.clientlogin.ClientLoginResponseException;
import org.gradle.internal.impldep.com.google.api.client.http.GenericUrl;
import org.gradle.internal.impldep.com.google.api.client.http.HttpExecuteInterceptor;
import org.gradle.internal.impldep.com.google.api.client.http.HttpRequest;
import org.gradle.internal.impldep.com.google.api.client.http.HttpRequestInitializer;
import org.gradle.internal.impldep.com.google.api.client.http.HttpResponse;
import org.gradle.internal.impldep.com.google.api.client.http.HttpResponseException;
import org.gradle.internal.impldep.com.google.api.client.http.HttpTransport;
import org.gradle.internal.impldep.com.google.api.client.http.UrlEncodedContent;
import org.gradle.internal.impldep.com.google.api.client.util.Beta;
import org.gradle.internal.impldep.com.google.api.client.util.Key;
import org.gradle.internal.impldep.com.google.api.client.util.StringUtils;
import org.gradle.internal.impldep.com.google.api.client.util.Strings;

@Beta
public final class ClientLogin {
    public HttpTransport transport;
    public GenericUrl serverUrl = new GenericUrl("https://www.google.com");
    @Key(value="source")
    public String applicationName;
    @Key(value="service")
    public String authTokenType;
    @Key(value="Email")
    public String username;
    @Key(value="Passwd")
    public String password;
    @Key
    public String accountType;
    @Key(value="logintoken")
    public String captchaToken;
    @Key(value="logincaptcha")
    public String captchaAnswer;

    public Response authenticate() throws IOException {
        GenericUrl url = this.serverUrl.clone();
        url.appendRawPath("/accounts/ClientLogin");
        HttpRequest request = this.transport.createRequestFactory().buildPostRequest(url, new UrlEncodedContent(this));
        request.setParser(AuthKeyValueParser.INSTANCE);
        request.setContentLoggingLimit(0);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        if (response.isSuccessStatusCode()) {
            return response.parseAs(Response.class);
        }
        HttpResponseException.Builder builder = new HttpResponseException.Builder(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
        ErrorInfo details = response.parseAs(ErrorInfo.class);
        String detailString = details.toString();
        StringBuilder message2 = HttpResponseException.computeMessageBuffer(response);
        if (!Strings.isNullOrEmpty(detailString)) {
            message2.append(StringUtils.LINE_SEPARATOR).append(detailString);
            builder.setContent(detailString);
        }
        builder.setMessage(message2.toString());
        throw new ClientLoginResponseException(builder, details);
    }

    public static String getAuthorizationHeaderValue(String authToken) {
        return "GoogleLogin auth=" + authToken;
    }

    public static final class ErrorInfo {
        @Key(value="Error")
        public String error;
        @Key(value="Url")
        public String url;
        @Key(value="CaptchaToken")
        public String captchaToken;
        @Key(value="CaptchaUrl")
        public String captchaUrl;
    }

    public static final class Response
    implements HttpExecuteInterceptor,
    HttpRequestInitializer {
        @Key(value="Auth")
        public String auth;

        public String getAuthorizationHeaderValue() {
            return ClientLogin.getAuthorizationHeaderValue(this.auth);
        }

        @Override
        public void initialize(HttpRequest request) {
            request.setInterceptor(this);
        }

        @Override
        public void intercept(HttpRequest request) {
            request.getHeaders().setAuthorization(this.getAuthorizationHeaderValue());
        }
    }
}

