/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.api.services.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.gradle.internal.impldep.com.google.api.client.googleapis.GoogleUtils;
import org.gradle.internal.impldep.com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import org.gradle.internal.impldep.com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import org.gradle.internal.impldep.com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import org.gradle.internal.impldep.com.google.api.client.http.AbstractInputStreamContent;
import org.gradle.internal.impldep.com.google.api.client.http.GenericUrl;
import org.gradle.internal.impldep.com.google.api.client.http.HttpRequest;
import org.gradle.internal.impldep.com.google.api.client.http.HttpRequestInitializer;
import org.gradle.internal.impldep.com.google.api.client.http.HttpResponse;
import org.gradle.internal.impldep.com.google.api.client.http.HttpTransport;
import org.gradle.internal.impldep.com.google.api.client.http.UriTemplate;
import org.gradle.internal.impldep.com.google.api.client.json.JsonFactory;
import org.gradle.internal.impldep.com.google.api.client.util.Key;
import org.gradle.internal.impldep.com.google.api.client.util.Preconditions;
import org.gradle.internal.impldep.com.google.api.services.storage.StorageRequest;
import org.gradle.internal.impldep.com.google.api.services.storage.StorageRequestInitializer;
import org.gradle.internal.impldep.com.google.api.services.storage.model.Bucket;
import org.gradle.internal.impldep.com.google.api.services.storage.model.BucketAccessControl;
import org.gradle.internal.impldep.com.google.api.services.storage.model.Channel;
import org.gradle.internal.impldep.com.google.api.services.storage.model.ComposeRequest;
import org.gradle.internal.impldep.com.google.api.services.storage.model.HmacKey;
import org.gradle.internal.impldep.com.google.api.services.storage.model.HmacKeyMetadata;
import org.gradle.internal.impldep.com.google.api.services.storage.model.HmacKeysMetadata;
import org.gradle.internal.impldep.com.google.api.services.storage.model.Notification;
import org.gradle.internal.impldep.com.google.api.services.storage.model.ObjectAccessControl;
import org.gradle.internal.impldep.com.google.api.services.storage.model.Policy;
import org.gradle.internal.impldep.com.google.api.services.storage.model.RewriteResponse;
import org.gradle.internal.impldep.com.google.api.services.storage.model.ServiceAccount;
import org.gradle.internal.impldep.com.google.api.services.storage.model.StorageObject;
import org.gradle.internal.impldep.com.google.api.services.storage.model.TestIamPermissionsResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storage
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://storage.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "storage/v1/";
    public static final String DEFAULT_BATCH_PATH = "batch/storage/v1";
    public static final String DEFAULT_BASE_URL = "https://storage.googleapis.com/storage/v1/";

    public Storage(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Storage(Builder builder) {
        super(builder);
    }

    @Override
    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public BucketAccessControls bucketAccessControls() {
        return new BucketAccessControls();
    }

    public Buckets buckets() {
        return new Buckets();
    }

    public Channels channels() {
        return new Channels();
    }

    public DefaultObjectAccessControls defaultObjectAccessControls() {
        return new DefaultObjectAccessControls();
    }

    public Notifications notifications() {
        return new Notifications();
    }

    public ObjectAccessControls objectAccessControls() {
        return new ObjectAccessControls();
    }

    public Objects objects() {
        return new Objects();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState(GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15, "You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Cloud Storage JSON API library.", GoogleUtils.VERSION);
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Storage.DEFAULT_ROOT_URL, Storage.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Storage.DEFAULT_BATCH_PATH);
        }

        public Storage build() {
            return new Storage(this);
        }

        public Builder setRootUrl(String string2) {
            return (Builder)super.setRootUrl(string2);
        }

        public Builder setServicePath(String string2) {
            return (Builder)super.setServicePath(string2);
        }

        public Builder setBatchPath(String string2) {
            return (Builder)super.setBatchPath(string2);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string2) {
            return (Builder)super.setApplicationName(string2);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setStorageRequestInitializer(StorageRequestInitializer storageRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(storageRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public HmacKeys hmacKeys() {
            return new HmacKeys();
        }

        public ServiceAccount serviceAccount() {
            return new ServiceAccount();
        }

        public class ServiceAccount {
            public Get get(String string2) throws IOException {
                Get get = new Get(string2);
                Storage.this.initialize(get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends StorageRequest<org.gradle.internal.impldep.com.google.api.services.storage.model.ServiceAccount> {
                private static final String REST_PATH = "projects/{projectId}/serviceAccount";
                @Key
                private String projectId;
                @Key
                private String provisionalUserProject;
                @Key
                private String userProject;

                protected Get(String string2) {
                    super(Storage.this, "GET", REST_PATH, (Object)null, org.gradle.internal.impldep.com.google.api.services.storage.model.ServiceAccount.class);
                    this.projectId = Preconditions.checkNotNull(string2, "Required parameter projectId must be specified.");
                }

                @Override
                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                @Override
                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string2) {
                    return (Get)super.setAlt(string2);
                }

                public Get setFields(String string2) {
                    return (Get)super.setFields(string2);
                }

                public Get setKey(String string2) {
                    return (Get)super.setKey(string2);
                }

                public Get setOauthToken(String string2) {
                    return (Get)super.setOauthToken(string2);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string2) {
                    return (Get)super.setQuotaUser(string2);
                }

                public Get setUserIp(String string2) {
                    return (Get)super.setUserIp(string2);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String string2) {
                    this.projectId = string2;
                    return this;
                }

                public String getProvisionalUserProject() {
                    return this.provisionalUserProject;
                }

                public Get setProvisionalUserProject(String string2) {
                    this.provisionalUserProject = string2;
                    return this;
                }

                public String getUserProject() {
                    return this.userProject;
                }

                public Get setUserProject(String string2) {
                    this.userProject = string2;
                    return this;
                }

                @Override
                public Get set(String string2, Object object) {
                    return (Get)super.set(string2, object);
                }
            }
        }

        public class HmacKeys {
            public Create create(String string2, String string3) throws IOException {
                Create create = new Create(string2, string3);
                Storage.this.initialize(create);
                return create;
            }

            public Delete delete(String string2, String string3) throws IOException {
                Delete delete = new Delete(string2, string3);
                Storage.this.initialize(delete);
                return delete;
            }

            public Get get(String string2, String string3) throws IOException {
                Get get = new Get(string2, string3);
                Storage.this.initialize(get);
                return get;
            }

            public List list(String string2) throws IOException {
                List list = new List(string2);
                Storage.this.initialize(list);
                return list;
            }

            public Update update(String string2, String string3, HmacKeyMetadata hmacKeyMetadata) throws IOException {
                Update update = new Update(string2, string3, hmacKeyMetadata);
                Storage.this.initialize(update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends StorageRequest<HmacKeyMetadata> {
                private static final String REST_PATH = "projects/{projectId}/hmacKeys/{accessId}";
                @Key
                private String projectId;
                @Key
                private String accessId;
                @Key
                private String userProject;

                protected Update(String string2, String string3, HmacKeyMetadata hmacKeyMetadata) {
                    super(Storage.this, "PUT", REST_PATH, (Object)hmacKeyMetadata, HmacKeyMetadata.class);
                    this.projectId = Preconditions.checkNotNull(string2, "Required parameter projectId must be specified.");
                    this.accessId = Preconditions.checkNotNull(string3, "Required parameter accessId must be specified.");
                }

                public Update setAlt(String string2) {
                    return (Update)super.setAlt(string2);
                }

                public Update setFields(String string2) {
                    return (Update)super.setFields(string2);
                }

                public Update setKey(String string2) {
                    return (Update)super.setKey(string2);
                }

                public Update setOauthToken(String string2) {
                    return (Update)super.setOauthToken(string2);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string2) {
                    return (Update)super.setQuotaUser(string2);
                }

                public Update setUserIp(String string2) {
                    return (Update)super.setUserIp(string2);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Update setProjectId(String string2) {
                    this.projectId = string2;
                    return this;
                }

                public String getAccessId() {
                    return this.accessId;
                }

                public Update setAccessId(String string2) {
                    this.accessId = string2;
                    return this;
                }

                public String getUserProject() {
                    return this.userProject;
                }

                public Update setUserProject(String string2) {
                    this.userProject = string2;
                    return this;
                }

                @Override
                public Update set(String string2, Object object) {
                    return (Update)super.set(string2, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends StorageRequest<HmacKeysMetadata> {
                private static final String REST_PATH = "projects/{projectId}/hmacKeys";
                @Key
                private String projectId;
                @Key
                private Long maxResults;
                @Key
                private String pageToken;
                @Key
                private String serviceAccountEmail;
                @Key
                private Boolean showDeletedKeys;
                @Key
                private String userProject;

                protected List(String string2) {
                    super(Storage.this, "GET", REST_PATH, (Object)null, HmacKeysMetadata.class);
                    this.projectId = Preconditions.checkNotNull(string2, "Required parameter projectId must be specified.");
                }

                @Override
                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                @Override
                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string2) {
                    return (List)super.setAlt(string2);
                }

                public List setFields(String string2) {
                    return (List)super.setFields(string2);
                }

                public List setKey(String string2) {
                    return (List)super.setKey(string2);
                }

                public List setOauthToken(String string2) {
                    return (List)super.setOauthToken(string2);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string2) {
                    return (List)super.setQuotaUser(string2);
                }

                public List setUserIp(String string2) {
                    return (List)super.setUserIp(string2);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String string2) {
                    this.projectId = string2;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long l) {
                    this.maxResults = l;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string2) {
                    this.pageToken = string2;
                    return this;
                }

                public String getServiceAccountEmail() {
                    return this.serviceAccountEmail;
                }

                public List setServiceAccountEmail(String string2) {
                    this.serviceAccountEmail = string2;
                    return this;
                }

                public Boolean getShowDeletedKeys() {
                    return this.showDeletedKeys;
                }

                public List setShowDeletedKeys(Boolean bl) {
                    this.showDeletedKeys = bl;
                    return this;
                }

                public String getUserProject() {
                    return this.userProject;
                }

                public List setUserProject(String string2) {
                    this.userProject = string2;
                    return this;
                }

                @Override
                public List set(String string2, Object object) {
                    return (List)super.set(string2, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends StorageRequest<HmacKeyMetadata> {
                private static final String REST_PATH = "projects/{projectId}/hmacKeys/{accessId}";
                @Key
                private String projectId;
                @Key
                private String accessId;
                @Key
                private String userProject;

                protected Get(String string2, String string3) {
                    super(Storage.this, "GET", REST_PATH, (Object)null, HmacKeyMetadata.class);
                    this.projectId = Preconditions.checkNotNull(string2, "Required parameter projectId must be specified.");
                    this.accessId = Preconditions.checkNotNull(string3, "Required parameter accessId must be specified.");
                }

                @Override
                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                @Override
                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string2) {
                    return (Get)super.setAlt(string2);
                }

                public Get setFields(String string2) {
                    return (Get)super.setFields(string2);
                }

                public Get setKey(String string2) {
                    return (Get)super.setKey(string2);
                }

                public Get setOauthToken(String string2) {
                    return (Get)super.setOauthToken(string2);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string2) {
                    return (Get)super.setQuotaUser(string2);
                }

                public Get setUserIp(String string2) {
                    return (Get)super.setUserIp(string2);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String string2) {
                    this.projectId = string2;
                    return this;
                }

                public String getAccessId() {
                    return this.accessId;
                }

                public Get setAccessId(String string2) {
                    this.accessId = string2;
                    return this;
                }

                public String getUserProject() {
                    return this.userProject;
                }

                public Get setUserProject(String string2) {
                    this.userProject = string2;
                    return this;
                }

                @Override
                public Get set(String string2, Object object) {
                    return (Get)super.set(string2, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends StorageRequest<Void> {
                private static final String REST_PATH = "projects/{projectId}/hmacKeys/{accessId}";
                @Key
                private String projectId;
                @Key
                private String accessId;
                @Key
                private String userProject;

                protected Delete(String string2, String string3) {
                    super(Storage.this, "DELETE", REST_PATH, (Object)null, Void.class);
                    this.projectId = Preconditions.checkNotNull(string2, "Required parameter projectId must be specified.");
                    this.accessId = Preconditions.checkNotNull(string3, "Required parameter accessId must be specified.");
                }

                public Delete setAlt(String string2) {
                    return (Delete)super.setAlt(string2);
                }

                public Delete setFields(String string2) {
                    return (Delete)super.setFields(string2);
                }

                public Delete setKey(String string2) {
                    return (Delete)super.setKey(string2);
                }

                public Delete setOauthToken(String string2) {
                    return (Delete)super.setOauthToken(string2);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string2) {
                    return (Delete)super.setQuotaUser(string2);
                }

                public Delete setUserIp(String string2) {
                    return (Delete)super.setUserIp(string2);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Delete setProjectId(String string2) {
                    this.projectId = string2;
                    return this;
                }

                public String getAccessId() {
                    return this.accessId;
                }

                public Delete setAccessId(String string2) {
                    this.accessId = string2;
                    return this;
                }

                public String getUserProject() {
                    return this.userProject;
                }

                public Delete setUserProject(String string2) {
                    this.userProject = string2;
                    return this;
                }

                @Override
                public Delete set(String string2, Object object) {
                    return (Delete)super.set(string2, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends StorageRequest<HmacKey> {
                private static final String REST_PATH = "projects/{projectId}/hmacKeys";
                @Key
                private String projectId;
                @Key
                private String serviceAccountEmail;
                @Key
                private String userProject;

                protected Create(String string2, String string3) {
                    super(Storage.this, "POST", REST_PATH, (Object)null, HmacKey.class);
                    this.projectId = Preconditions.checkNotNull(string2, "Required parameter projectId must be specified.");
                    this.serviceAccountEmail = Preconditions.checkNotNull(string3, "Required parameter serviceAccountEmail must be specified.");
                }

                public Create setAlt(String string2) {
                    return (Create)super.setAlt(string2);
                }

                public Create setFields(String string2) {
                    return (Create)super.setFields(string2);
                }

                public Create setKey(String string2) {
                    return (Create)super.setKey(string2);
                }

                public Create setOauthToken(String string2) {
                    return (Create)super.setOauthToken(string2);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string2) {
                    return (Create)super.setQuotaUser(string2);
                }

                public Create setUserIp(String string2) {
                    return (Create)super.setUserIp(string2);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String string2) {
                    this.projectId = string2;
                    return this;
                }

                public String getServiceAccountEmail() {
                    return this.serviceAccountEmail;
                }

                public Create setServiceAccountEmail(String string2) {
                    this.serviceAccountEmail = string2;
                    return this;
                }

                public String getUserProject() {
                    return this.userProject;
                }

                public Create setUserProject(String string2) {
                    this.userProject = string2;
                    return this;
                }

                @Override
                public Create set(String string2, Object object) {
                    return (Create)super.set(string2, object);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Objects {
        public Compose compose(String string2, String string3, ComposeRequest composeRequest) throws IOException {
            Compose compose = new Compose(string2, string3, composeRequest);
            Storage.this.initialize(compose);
            return compose;
        }

        public Copy copy(String string2, String string3, String string4, String string5, StorageObject storageObject) throws IOException {
            Copy copy = new Copy(string2, string3, string4, string5, storageObject);
            Storage.this.initialize(copy);
            return copy;
        }

        public Delete delete(String string2, String string3) throws IOException {
            Delete delete = new Delete(string2, string3);
            Storage.this.initialize(delete);
            return delete;
        }

        public Get get(String string2, String string3) throws IOException {
            Get get = new Get(string2, string3);
            Storage.this.initialize(get);
            return get;
        }

        public GetIamPolicy getIamPolicy(String string2, String string3) throws IOException {
            GetIamPolicy getIamPolicy = new GetIamPolicy(string2, string3);
            Storage.this.initialize(getIamPolicy);
            return getIamPolicy;
        }

        public Insert insert(String string2, StorageObject storageObject) throws IOException {
            Insert insert = new Insert(string2, storageObject);
            Storage.this.initialize(insert);
            return insert;
        }

        public Insert insert(String string2, StorageObject storageObject, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(string2, storageObject, abstractInputStreamContent);
            Storage.this.initialize(insert);
            return insert;
        }

        public List list(String string2) throws IOException {
            List list = new List(string2);
            Storage.this.initialize(list);
            return list;
        }

        public Patch patch(String string2, String string3, StorageObject storageObject) throws IOException {
            Patch patch = new Patch(string2, string3, storageObject);
            Storage.this.initialize(patch);
            return patch;
        }

        public Rewrite rewrite(String string2, String string3, String string4, String string5, StorageObject storageObject) throws IOException {
            Rewrite rewrite = new Rewrite(string2, string3, string4, string5, storageObject);
            Storage.this.initialize(rewrite);
            return rewrite;
        }

        public SetIamPolicy setIamPolicy(String string2, String string3, Policy policy) throws IOException {
            SetIamPolicy setIamPolicy = new SetIamPolicy(string2, string3, policy);
            Storage.this.initialize(setIamPolicy);
            return setIamPolicy;
        }

        public TestIamPermissions testIamPermissions(String string2, String string3, java.util.List<String> list) throws IOException {
            TestIamPermissions testIamPermissions = new TestIamPermissions(string2, string3, list);
            Storage.this.initialize(testIamPermissions);
            return testIamPermissions;
        }

        public Update update(String string2, String string3, StorageObject storageObject) throws IOException {
            Update update = new Update(string2, string3, storageObject);
            Storage.this.initialize(update);
            return update;
        }

        public WatchAll watchAll(String string2, Channel channel) throws IOException {
            WatchAll watchAll = new WatchAll(string2, channel);
            Storage.this.initialize(watchAll);
            return watchAll;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class WatchAll
        extends StorageRequest<Channel> {
            private static final String REST_PATH = "b/{bucket}/o/watch";
            @Key
            private String bucket;
            @Key
            private String delimiter;
            @Key
            private String endOffset;
            @Key
            private Boolean includeTrailingDelimiter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String prefix;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String startOffset;
            @Key
            private String userProject;
            @Key
            private Boolean versions;

            protected WatchAll(String string2, Channel channel) {
                super(Storage.this, "POST", REST_PATH, (Object)channel, Channel.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            public WatchAll setAlt(String string2) {
                return (WatchAll)super.setAlt(string2);
            }

            public WatchAll setFields(String string2) {
                return (WatchAll)super.setFields(string2);
            }

            public WatchAll setKey(String string2) {
                return (WatchAll)super.setKey(string2);
            }

            public WatchAll setOauthToken(String string2) {
                return (WatchAll)super.setOauthToken(string2);
            }

            public WatchAll setPrettyPrint(Boolean bl) {
                return (WatchAll)super.setPrettyPrint(bl);
            }

            public WatchAll setQuotaUser(String string2) {
                return (WatchAll)super.setQuotaUser(string2);
            }

            public WatchAll setUserIp(String string2) {
                return (WatchAll)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public WatchAll setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public WatchAll setDelimiter(String string2) {
                this.delimiter = string2;
                return this;
            }

            public String getEndOffset() {
                return this.endOffset;
            }

            public WatchAll setEndOffset(String string2) {
                this.endOffset = string2;
                return this;
            }

            public Boolean getIncludeTrailingDelimiter() {
                return this.includeTrailingDelimiter;
            }

            public WatchAll setIncludeTrailingDelimiter(Boolean bl) {
                this.includeTrailingDelimiter = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public WatchAll setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public WatchAll setPageToken(String string2) {
                this.pageToken = string2;
                return this;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public WatchAll setPrefix(String string2) {
                this.prefix = string2;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public WatchAll setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public WatchAll setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getStartOffset() {
                return this.startOffset;
            }

            public WatchAll setStartOffset(String string2) {
                this.startOffset = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public WatchAll setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            public Boolean getVersions() {
                return this.versions;
            }

            public WatchAll setVersions(Boolean bl) {
                this.versions = bl;
                return this;
            }

            @Override
            public WatchAll set(String string2, Object object) {
                return (WatchAll)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private Long generation;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String predefinedAcl;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Update(String string2, String string3, StorageObject storageObject) {
                super(Storage.this, "PUT", REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
            }

            public Update setAlt(String string2) {
                return (Update)super.setAlt(string2);
            }

            public Update setFields(String string2) {
                return (Update)super.setFields(string2);
            }

            public Update setKey(String string2) {
                return (Update)super.setKey(string2);
            }

            public Update setOauthToken(String string2) {
                return (Update)super.setOauthToken(string2);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string2) {
                return (Update)super.setQuotaUser(string2);
            }

            public Update setUserIp(String string2) {
                return (Update)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Update setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Update setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Update setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Update setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Update setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Update setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Update setPredefinedAcl(String string2) {
                this.predefinedAcl = string2;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Update setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Update setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Update set(String string2, Object object) {
                return (Update)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TestIamPermissions
        extends StorageRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/iam/testPermissions";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private java.util.List<String> permissions;
            @Key
            private Long generation;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected TestIamPermissions(String string2, String string3, java.util.List<String> list) {
                super(Storage.this, "GET", REST_PATH, (Object)null, TestIamPermissionsResponse.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
                this.permissions = Preconditions.checkNotNull(list, "Required parameter permissions must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public TestIamPermissions setAlt(String string2) {
                return (TestIamPermissions)super.setAlt(string2);
            }

            public TestIamPermissions setFields(String string2) {
                return (TestIamPermissions)super.setFields(string2);
            }

            public TestIamPermissions setKey(String string2) {
                return (TestIamPermissions)super.setKey(string2);
            }

            public TestIamPermissions setOauthToken(String string2) {
                return (TestIamPermissions)super.setOauthToken(string2);
            }

            public TestIamPermissions setPrettyPrint(Boolean bl) {
                return (TestIamPermissions)super.setPrettyPrint(bl);
            }

            public TestIamPermissions setQuotaUser(String string2) {
                return (TestIamPermissions)super.setQuotaUser(string2);
            }

            public TestIamPermissions setUserIp(String string2) {
                return (TestIamPermissions)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public TestIamPermissions setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public TestIamPermissions setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public java.util.List<String> getPermissions() {
                return this.permissions;
            }

            public TestIamPermissions setPermissions(java.util.List<String> list) {
                this.permissions = list;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public TestIamPermissions setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public TestIamPermissions setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public TestIamPermissions setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public TestIamPermissions set(String string2, Object object) {
                return (TestIamPermissions)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetIamPolicy
        extends StorageRequest<Policy> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/iam";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private Long generation;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected SetIamPolicy(String string2, String string3, Policy policy) {
                super(Storage.this, "PUT", REST_PATH, (Object)policy, Policy.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
            }

            public SetIamPolicy setAlt(String string2) {
                return (SetIamPolicy)super.setAlt(string2);
            }

            public SetIamPolicy setFields(String string2) {
                return (SetIamPolicy)super.setFields(string2);
            }

            public SetIamPolicy setKey(String string2) {
                return (SetIamPolicy)super.setKey(string2);
            }

            public SetIamPolicy setOauthToken(String string2) {
                return (SetIamPolicy)super.setOauthToken(string2);
            }

            public SetIamPolicy setPrettyPrint(Boolean bl) {
                return (SetIamPolicy)super.setPrettyPrint(bl);
            }

            public SetIamPolicy setQuotaUser(String string2) {
                return (SetIamPolicy)super.setQuotaUser(string2);
            }

            public SetIamPolicy setUserIp(String string2) {
                return (SetIamPolicy)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public SetIamPolicy setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public SetIamPolicy setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public SetIamPolicy setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public SetIamPolicy setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public SetIamPolicy setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public SetIamPolicy set(String string2, Object object) {
                return (SetIamPolicy)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Rewrite
        extends StorageRequest<RewriteResponse> {
            private static final String REST_PATH = "b/{sourceBucket}/o/{sourceObject}/rewriteTo/b/{destinationBucket}/o/{destinationObject}";
            @Key
            private String sourceBucket;
            @Key
            private String sourceObject;
            @Key
            private String destinationBucket;
            @Key
            private String destinationObject;
            @Key
            private String destinationKmsKeyName;
            @Key
            private String destinationPredefinedAcl;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private Long ifSourceGenerationMatch;
            @Key
            private Long ifSourceGenerationNotMatch;
            @Key
            private Long ifSourceMetagenerationMatch;
            @Key
            private Long ifSourceMetagenerationNotMatch;
            @Key
            private Long maxBytesRewrittenPerCall;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String rewriteToken;
            @Key
            private Long sourceGeneration;
            @Key
            private String userProject;

            protected Rewrite(String string2, String string3, String string4, String string5, StorageObject storageObject) {
                super(Storage.this, "POST", REST_PATH, (Object)storageObject, RewriteResponse.class);
                this.sourceBucket = Preconditions.checkNotNull(string2, "Required parameter sourceBucket must be specified.");
                this.sourceObject = Preconditions.checkNotNull(string3, "Required parameter sourceObject must be specified.");
                this.destinationBucket = Preconditions.checkNotNull(string4, "Required parameter destinationBucket must be specified.");
                this.destinationObject = Preconditions.checkNotNull(string5, "Required parameter destinationObject must be specified.");
            }

            public Rewrite setAlt(String string2) {
                return (Rewrite)super.setAlt(string2);
            }

            public Rewrite setFields(String string2) {
                return (Rewrite)super.setFields(string2);
            }

            public Rewrite setKey(String string2) {
                return (Rewrite)super.setKey(string2);
            }

            public Rewrite setOauthToken(String string2) {
                return (Rewrite)super.setOauthToken(string2);
            }

            public Rewrite setPrettyPrint(Boolean bl) {
                return (Rewrite)super.setPrettyPrint(bl);
            }

            public Rewrite setQuotaUser(String string2) {
                return (Rewrite)super.setQuotaUser(string2);
            }

            public Rewrite setUserIp(String string2) {
                return (Rewrite)super.setUserIp(string2);
            }

            public String getSourceBucket() {
                return this.sourceBucket;
            }

            public Rewrite setSourceBucket(String string2) {
                this.sourceBucket = string2;
                return this;
            }

            public String getSourceObject() {
                return this.sourceObject;
            }

            public Rewrite setSourceObject(String string2) {
                this.sourceObject = string2;
                return this;
            }

            public String getDestinationBucket() {
                return this.destinationBucket;
            }

            public Rewrite setDestinationBucket(String string2) {
                this.destinationBucket = string2;
                return this;
            }

            public String getDestinationObject() {
                return this.destinationObject;
            }

            public Rewrite setDestinationObject(String string2) {
                this.destinationObject = string2;
                return this;
            }

            public String getDestinationKmsKeyName() {
                return this.destinationKmsKeyName;
            }

            public Rewrite setDestinationKmsKeyName(String string2) {
                this.destinationKmsKeyName = string2;
                return this;
            }

            public String getDestinationPredefinedAcl() {
                return this.destinationPredefinedAcl;
            }

            public Rewrite setDestinationPredefinedAcl(String string2) {
                this.destinationPredefinedAcl = string2;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Rewrite setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Rewrite setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Rewrite setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Rewrite setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public Long getIfSourceGenerationMatch() {
                return this.ifSourceGenerationMatch;
            }

            public Rewrite setIfSourceGenerationMatch(Long l) {
                this.ifSourceGenerationMatch = l;
                return this;
            }

            public Long getIfSourceGenerationNotMatch() {
                return this.ifSourceGenerationNotMatch;
            }

            public Rewrite setIfSourceGenerationNotMatch(Long l) {
                this.ifSourceGenerationNotMatch = l;
                return this;
            }

            public Long getIfSourceMetagenerationMatch() {
                return this.ifSourceMetagenerationMatch;
            }

            public Rewrite setIfSourceMetagenerationMatch(Long l) {
                this.ifSourceMetagenerationMatch = l;
                return this;
            }

            public Long getIfSourceMetagenerationNotMatch() {
                return this.ifSourceMetagenerationNotMatch;
            }

            public Rewrite setIfSourceMetagenerationNotMatch(Long l) {
                this.ifSourceMetagenerationNotMatch = l;
                return this;
            }

            public Long getMaxBytesRewrittenPerCall() {
                return this.maxBytesRewrittenPerCall;
            }

            public Rewrite setMaxBytesRewrittenPerCall(Long l) {
                this.maxBytesRewrittenPerCall = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Rewrite setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Rewrite setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getRewriteToken() {
                return this.rewriteToken;
            }

            public Rewrite setRewriteToken(String string2) {
                this.rewriteToken = string2;
                return this;
            }

            public Long getSourceGeneration() {
                return this.sourceGeneration;
            }

            public Rewrite setSourceGeneration(Long l) {
                this.sourceGeneration = l;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Rewrite setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Rewrite set(String string2, Object object) {
                return (Rewrite)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private Long generation;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String predefinedAcl;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Patch(String string2, String string3, StorageObject storageObject) {
                super(Storage.this, "PATCH", REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
            }

            public Patch setAlt(String string2) {
                return (Patch)super.setAlt(string2);
            }

            public Patch setFields(String string2) {
                return (Patch)super.setFields(string2);
            }

            public Patch setKey(String string2) {
                return (Patch)super.setKey(string2);
            }

            public Patch setOauthToken(String string2) {
                return (Patch)super.setOauthToken(string2);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string2) {
                return (Patch)super.setQuotaUser(string2);
            }

            public Patch setUserIp(String string2) {
                return (Patch)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Patch setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Patch setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Patch setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Patch setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Patch setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Patch setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Patch setPredefinedAcl(String string2) {
                this.predefinedAcl = string2;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Patch setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Patch setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Patch set(String string2, Object object) {
                return (Patch)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<org.gradle.internal.impldep.com.google.api.services.storage.model.Objects> {
            private static final String REST_PATH = "b/{bucket}/o";
            @Key
            private String bucket;
            @Key
            private String delimiter;
            @Key
            private String endOffset;
            @Key
            private Boolean includeTrailingDelimiter;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String prefix;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String startOffset;
            @Key
            private String userProject;
            @Key
            private Boolean versions;

            protected List(String string2) {
                super(Storage.this, "GET", REST_PATH, (Object)null, org.gradle.internal.impldep.com.google.api.services.storage.model.Objects.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string2) {
                return (List)super.setAlt(string2);
            }

            public List setFields(String string2) {
                return (List)super.setFields(string2);
            }

            public List setKey(String string2) {
                return (List)super.setKey(string2);
            }

            public List setOauthToken(String string2) {
                return (List)super.setOauthToken(string2);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string2) {
                return (List)super.setQuotaUser(string2);
            }

            public List setUserIp(String string2) {
                return (List)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public List setDelimiter(String string2) {
                this.delimiter = string2;
                return this;
            }

            public String getEndOffset() {
                return this.endOffset;
            }

            public List setEndOffset(String string2) {
                this.endOffset = string2;
                return this;
            }

            public Boolean getIncludeTrailingDelimiter() {
                return this.includeTrailingDelimiter;
            }

            public List setIncludeTrailingDelimiter(Boolean bl) {
                this.includeTrailingDelimiter = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string2) {
                this.pageToken = string2;
                return this;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public List setPrefix(String string2) {
                this.prefix = string2;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public List setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getStartOffset() {
                return this.startOffset;
            }

            public List setStartOffset(String string2) {
                this.startOffset = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public List setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            public Boolean getVersions() {
                return this.versions;
            }

            public List setVersions(Boolean bl) {
                this.versions = bl;
                return this;
            }

            @Override
            public List set(String string2, Object object) {
                return (List)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o";
            @Key
            private String bucket;
            @Key
            private String contentEncoding;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String kmsKeyName;
            @Key
            private String name;
            @Key
            private String predefinedAcl;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Insert(String string2, StorageObject storageObject) {
                super(Storage.this, "POST", REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            protected Insert(String string2, StorageObject storageObject, AbstractInputStreamContent abstractInputStreamContent) {
                super(Storage.this, "POST", "/upload/" + Storage.this.getServicePath() + REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Insert setAlt(String string2) {
                return (Insert)super.setAlt(string2);
            }

            public Insert setFields(String string2) {
                return (Insert)super.setFields(string2);
            }

            public Insert setKey(String string2) {
                return (Insert)super.setKey(string2);
            }

            public Insert setOauthToken(String string2) {
                return (Insert)super.setOauthToken(string2);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string2) {
                return (Insert)super.setQuotaUser(string2);
            }

            public Insert setUserIp(String string2) {
                return (Insert)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getContentEncoding() {
                return this.contentEncoding;
            }

            public Insert setContentEncoding(String string2) {
                this.contentEncoding = string2;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Insert setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Insert setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Insert setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Insert setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getKmsKeyName() {
                return this.kmsKeyName;
            }

            public Insert setKmsKeyName(String string2) {
                this.kmsKeyName = string2;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Insert setName(String string2) {
                this.name = string2;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Insert setPredefinedAcl(String string2) {
                this.predefinedAcl = string2;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Insert setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Insert setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Insert setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Insert set(String string2, Object object) {
                return (Insert)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIamPolicy
        extends StorageRequest<Policy> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/iam";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private Long generation;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected GetIamPolicy(String string2, String string3) {
                super(Storage.this, "GET", REST_PATH, (Object)null, Policy.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIamPolicy setAlt(String string2) {
                return (GetIamPolicy)super.setAlt(string2);
            }

            public GetIamPolicy setFields(String string2) {
                return (GetIamPolicy)super.setFields(string2);
            }

            public GetIamPolicy setKey(String string2) {
                return (GetIamPolicy)super.setKey(string2);
            }

            public GetIamPolicy setOauthToken(String string2) {
                return (GetIamPolicy)super.setOauthToken(string2);
            }

            public GetIamPolicy setPrettyPrint(Boolean bl) {
                return (GetIamPolicy)super.setPrettyPrint(bl);
            }

            public GetIamPolicy setQuotaUser(String string2) {
                return (GetIamPolicy)super.setQuotaUser(string2);
            }

            public GetIamPolicy setUserIp(String string2) {
                return (GetIamPolicy)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public GetIamPolicy setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public GetIamPolicy setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public GetIamPolicy setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public GetIamPolicy setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public GetIamPolicy setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public GetIamPolicy set(String string2, Object object) {
                return (GetIamPolicy)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private Long generation;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Get(String string2, String string3) {
                super(Storage.this, "GET", REST_PATH, (Object)null, StorageObject.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
                this.initializeMediaDownload();
            }

            @Override
            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            @Override
            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            @Override
            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            @Override
            public GenericUrl buildHttpRequestUrl() {
                String string2 = "media".equals(this.get("alt")) && this.getMediaHttpUploader() == null ? Storage.this.getRootUrl() + "download/" + Storage.this.getServicePath() : Storage.this.getBaseUrl();
                return new GenericUrl(UriTemplate.expand(string2, this.getUriTemplate(), this, true));
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string2) {
                return (Get)super.setAlt(string2);
            }

            public Get setFields(String string2) {
                return (Get)super.setFields(string2);
            }

            public Get setKey(String string2) {
                return (Get)super.setKey(string2);
            }

            public Get setOauthToken(String string2) {
                return (Get)super.setOauthToken(string2);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string2) {
                return (Get)super.setQuotaUser(string2);
            }

            public Get setUserIp(String string2) {
                return (Get)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Get setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Get setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Get setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Get setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Get setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Get setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Get setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Get setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Get set(String string2, Object object) {
                return (Get)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private Long generation;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Delete(String string2, String string3) {
                super(Storage.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
            }

            public Delete setAlt(String string2) {
                return (Delete)super.setAlt(string2);
            }

            public Delete setFields(String string2) {
                return (Delete)super.setFields(string2);
            }

            public Delete setKey(String string2) {
                return (Delete)super.setKey(string2);
            }

            public Delete setOauthToken(String string2) {
                return (Delete)super.setOauthToken(string2);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string2) {
                return (Delete)super.setQuotaUser(string2);
            }

            public Delete setUserIp(String string2) {
                return (Delete)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Delete setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Delete setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Delete setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Delete setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Delete setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Delete setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Delete setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Delete setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Delete set(String string2, Object object) {
                return (Delete)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Copy
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{sourceBucket}/o/{sourceObject}/copyTo/b/{destinationBucket}/o/{destinationObject}";
            @Key
            private String sourceBucket;
            @Key
            private String sourceObject;
            @Key
            private String destinationBucket;
            @Key
            private String destinationObject;
            @Key
            private String destinationPredefinedAcl;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifGenerationNotMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private Long ifSourceGenerationMatch;
            @Key
            private Long ifSourceGenerationNotMatch;
            @Key
            private Long ifSourceMetagenerationMatch;
            @Key
            private Long ifSourceMetagenerationNotMatch;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private Long sourceGeneration;
            @Key
            private String userProject;

            protected Copy(String string2, String string3, String string4, String string5, StorageObject storageObject) {
                super(Storage.this, "POST", REST_PATH, (Object)storageObject, StorageObject.class);
                this.sourceBucket = Preconditions.checkNotNull(string2, "Required parameter sourceBucket must be specified.");
                this.sourceObject = Preconditions.checkNotNull(string3, "Required parameter sourceObject must be specified.");
                this.destinationBucket = Preconditions.checkNotNull(string4, "Required parameter destinationBucket must be specified.");
                this.destinationObject = Preconditions.checkNotNull(string5, "Required parameter destinationObject must be specified.");
            }

            public Copy setAlt(String string2) {
                return (Copy)super.setAlt(string2);
            }

            public Copy setFields(String string2) {
                return (Copy)super.setFields(string2);
            }

            public Copy setKey(String string2) {
                return (Copy)super.setKey(string2);
            }

            public Copy setOauthToken(String string2) {
                return (Copy)super.setOauthToken(string2);
            }

            public Copy setPrettyPrint(Boolean bl) {
                return (Copy)super.setPrettyPrint(bl);
            }

            public Copy setQuotaUser(String string2) {
                return (Copy)super.setQuotaUser(string2);
            }

            public Copy setUserIp(String string2) {
                return (Copy)super.setUserIp(string2);
            }

            public String getSourceBucket() {
                return this.sourceBucket;
            }

            public Copy setSourceBucket(String string2) {
                this.sourceBucket = string2;
                return this;
            }

            public String getSourceObject() {
                return this.sourceObject;
            }

            public Copy setSourceObject(String string2) {
                this.sourceObject = string2;
                return this;
            }

            public String getDestinationBucket() {
                return this.destinationBucket;
            }

            public Copy setDestinationBucket(String string2) {
                this.destinationBucket = string2;
                return this;
            }

            public String getDestinationObject() {
                return this.destinationObject;
            }

            public Copy setDestinationObject(String string2) {
                this.destinationObject = string2;
                return this;
            }

            public String getDestinationPredefinedAcl() {
                return this.destinationPredefinedAcl;
            }

            public Copy setDestinationPredefinedAcl(String string2) {
                this.destinationPredefinedAcl = string2;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Copy setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfGenerationNotMatch() {
                return this.ifGenerationNotMatch;
            }

            public Copy setIfGenerationNotMatch(Long l) {
                this.ifGenerationNotMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Copy setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Copy setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public Long getIfSourceGenerationMatch() {
                return this.ifSourceGenerationMatch;
            }

            public Copy setIfSourceGenerationMatch(Long l) {
                this.ifSourceGenerationMatch = l;
                return this;
            }

            public Long getIfSourceGenerationNotMatch() {
                return this.ifSourceGenerationNotMatch;
            }

            public Copy setIfSourceGenerationNotMatch(Long l) {
                this.ifSourceGenerationNotMatch = l;
                return this;
            }

            public Long getIfSourceMetagenerationMatch() {
                return this.ifSourceMetagenerationMatch;
            }

            public Copy setIfSourceMetagenerationMatch(Long l) {
                this.ifSourceMetagenerationMatch = l;
                return this;
            }

            public Long getIfSourceMetagenerationNotMatch() {
                return this.ifSourceMetagenerationNotMatch;
            }

            public Copy setIfSourceMetagenerationNotMatch(Long l) {
                this.ifSourceMetagenerationNotMatch = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Copy setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Copy setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public Long getSourceGeneration() {
                return this.sourceGeneration;
            }

            public Copy setSourceGeneration(Long l) {
                this.sourceGeneration = l;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Copy setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Copy set(String string2, Object object) {
                return (Copy)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Compose
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{destinationBucket}/o/{destinationObject}/compose";
            @Key
            private String destinationBucket;
            @Key
            private String destinationObject;
            @Key
            private String destinationPredefinedAcl;
            @Key
            private Long ifGenerationMatch;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private String kmsKeyName;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Compose(String string2, String string3, ComposeRequest composeRequest) {
                super(Storage.this, "POST", REST_PATH, (Object)composeRequest, StorageObject.class);
                this.destinationBucket = Preconditions.checkNotNull(string2, "Required parameter destinationBucket must be specified.");
                this.destinationObject = Preconditions.checkNotNull(string3, "Required parameter destinationObject must be specified.");
            }

            public Compose setAlt(String string2) {
                return (Compose)super.setAlt(string2);
            }

            public Compose setFields(String string2) {
                return (Compose)super.setFields(string2);
            }

            public Compose setKey(String string2) {
                return (Compose)super.setKey(string2);
            }

            public Compose setOauthToken(String string2) {
                return (Compose)super.setOauthToken(string2);
            }

            public Compose setPrettyPrint(Boolean bl) {
                return (Compose)super.setPrettyPrint(bl);
            }

            public Compose setQuotaUser(String string2) {
                return (Compose)super.setQuotaUser(string2);
            }

            public Compose setUserIp(String string2) {
                return (Compose)super.setUserIp(string2);
            }

            public String getDestinationBucket() {
                return this.destinationBucket;
            }

            public Compose setDestinationBucket(String string2) {
                this.destinationBucket = string2;
                return this;
            }

            public String getDestinationObject() {
                return this.destinationObject;
            }

            public Compose setDestinationObject(String string2) {
                this.destinationObject = string2;
                return this;
            }

            public String getDestinationPredefinedAcl() {
                return this.destinationPredefinedAcl;
            }

            public Compose setDestinationPredefinedAcl(String string2) {
                this.destinationPredefinedAcl = string2;
                return this;
            }

            public Long getIfGenerationMatch() {
                return this.ifGenerationMatch;
            }

            public Compose setIfGenerationMatch(Long l) {
                this.ifGenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Compose setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public String getKmsKeyName() {
                return this.kmsKeyName;
            }

            public Compose setKmsKeyName(String string2) {
                this.kmsKeyName = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Compose setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Compose setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Compose set(String string2, Object object) {
                return (Compose)super.set(string2, object);
            }
        }
    }

    public class ObjectAccessControls {
        public Delete delete(String string2, String string3, String string4) throws IOException {
            Delete delete = new Delete(string2, string3, string4);
            Storage.this.initialize(delete);
            return delete;
        }

        public Get get(String string2, String string3, String string4) throws IOException {
            Get get = new Get(string2, string3, string4);
            Storage.this.initialize(get);
            return get;
        }

        public Insert insert(String string2, String string3, ObjectAccessControl objectAccessControl) throws IOException {
            Insert insert = new Insert(string2, string3, objectAccessControl);
            Storage.this.initialize(insert);
            return insert;
        }

        public List list(String string2, String string3) throws IOException {
            List list = new List(string2, string3);
            Storage.this.initialize(list);
            return list;
        }

        public Patch patch(String string2, String string3, String string4, ObjectAccessControl objectAccessControl) throws IOException {
            Patch patch = new Patch(string2, string3, string4, objectAccessControl);
            Storage.this.initialize(patch);
            return patch;
        }

        public Update update(String string2, String string3, String string4, ObjectAccessControl objectAccessControl) throws IOException {
            Update update = new Update(string2, string3, string4, objectAccessControl);
            Storage.this.initialize(update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;
            @Key
            private Long generation;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Update(String string2, String string3, String string4, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "PUT", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
                this.entity = Preconditions.checkNotNull(string4, "Required parameter entity must be specified.");
            }

            public Update setAlt(String string2) {
                return (Update)super.setAlt(string2);
            }

            public Update setFields(String string2) {
                return (Update)super.setFields(string2);
            }

            public Update setKey(String string2) {
                return (Update)super.setKey(string2);
            }

            public Update setOauthToken(String string2) {
                return (Update)super.setOauthToken(string2);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string2) {
                return (Update)super.setQuotaUser(string2);
            }

            public Update setUserIp(String string2) {
                return (Update)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Update setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Update setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Update setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Update setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Update set(String string2, Object object) {
                return (Update)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;
            @Key
            private Long generation;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Patch(String string2, String string3, String string4, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "PATCH", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
                this.entity = Preconditions.checkNotNull(string4, "Required parameter entity must be specified.");
            }

            public Patch setAlt(String string2) {
                return (Patch)super.setAlt(string2);
            }

            public Patch setFields(String string2) {
                return (Patch)super.setFields(string2);
            }

            public Patch setKey(String string2) {
                return (Patch)super.setKey(string2);
            }

            public Patch setOauthToken(String string2) {
                return (Patch)super.setOauthToken(string2);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string2) {
                return (Patch)super.setQuotaUser(string2);
            }

            public Patch setUserIp(String string2) {
                return (Patch)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Patch setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Patch setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Patch setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Patch setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Patch set(String string2, Object object) {
                return (Patch)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<org.gradle.internal.impldep.com.google.api.services.storage.model.ObjectAccessControls> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private Long generation;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected List(String string2, String string3) {
                super(Storage.this, "GET", REST_PATH, (Object)null, org.gradle.internal.impldep.com.google.api.services.storage.model.ObjectAccessControls.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string2) {
                return (List)super.setAlt(string2);
            }

            public List setFields(String string2) {
                return (List)super.setFields(string2);
            }

            public List setKey(String string2) {
                return (List)super.setKey(string2);
            }

            public List setOauthToken(String string2) {
                return (List)super.setOauthToken(string2);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string2) {
                return (List)super.setQuotaUser(string2);
            }

            public List setUserIp(String string2) {
                return (List)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public List setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public List setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public List setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public List setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public List set(String string2, Object object) {
                return (List)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private Long generation;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Insert(String string2, String string3, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "POST", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
                this.checkRequiredParameter(objectAccessControl, "content");
                this.checkRequiredParameter(objectAccessControl.getEntity(), "ObjectAccessControl.getEntity()");
                this.checkRequiredParameter(objectAccessControl, "content");
                this.checkRequiredParameter(objectAccessControl.getRole(), "ObjectAccessControl.getRole()");
            }

            public Insert setAlt(String string2) {
                return (Insert)super.setAlt(string2);
            }

            public Insert setFields(String string2) {
                return (Insert)super.setFields(string2);
            }

            public Insert setKey(String string2) {
                return (Insert)super.setKey(string2);
            }

            public Insert setOauthToken(String string2) {
                return (Insert)super.setOauthToken(string2);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string2) {
                return (Insert)super.setQuotaUser(string2);
            }

            public Insert setUserIp(String string2) {
                return (Insert)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Insert setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Insert setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Insert setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Insert setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Insert set(String string2, Object object) {
                return (Insert)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;
            @Key
            private Long generation;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Get(String string2, String string3, String string4) {
                super(Storage.this, "GET", REST_PATH, (Object)null, ObjectAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
                this.entity = Preconditions.checkNotNull(string4, "Required parameter entity must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string2) {
                return (Get)super.setAlt(string2);
            }

            public Get setFields(String string2) {
                return (Get)super.setFields(string2);
            }

            public Get setKey(String string2) {
                return (Get)super.setKey(string2);
            }

            public Get setOauthToken(String string2) {
                return (Get)super.setOauthToken(string2);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string2) {
                return (Get)super.setQuotaUser(string2);
            }

            public Get setUserIp(String string2) {
                return (Get)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Get setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Get setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Get setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Get setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Get set(String string2, Object object) {
                return (Get)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;
            @Key
            private Long generation;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Delete(String string2, String string3, String string4) {
                super(Storage.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.object__ = Preconditions.checkNotNull(string3, "Required parameter object__ must be specified.");
                this.entity = Preconditions.checkNotNull(string4, "Required parameter entity must be specified.");
            }

            public Delete setAlt(String string2) {
                return (Delete)super.setAlt(string2);
            }

            public Delete setFields(String string2) {
                return (Delete)super.setFields(string2);
            }

            public Delete setKey(String string2) {
                return (Delete)super.setKey(string2);
            }

            public Delete setOauthToken(String string2) {
                return (Delete)super.setOauthToken(string2);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string2) {
                return (Delete)super.setQuotaUser(string2);
            }

            public Delete setUserIp(String string2) {
                return (Delete)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Delete setObject(String string2) {
                this.object__ = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public Long getGeneration() {
                return this.generation;
            }

            public Delete setGeneration(Long l) {
                this.generation = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Delete setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Delete setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Delete set(String string2, Object object) {
                return (Delete)super.set(string2, object);
            }
        }
    }

    public class Notifications {
        public Delete delete(String string2, String string3) throws IOException {
            Delete delete = new Delete(string2, string3);
            Storage.this.initialize(delete);
            return delete;
        }

        public Get get(String string2, String string3) throws IOException {
            Get get = new Get(string2, string3);
            Storage.this.initialize(get);
            return get;
        }

        public Insert insert(String string2, Notification notification) throws IOException {
            Insert insert = new Insert(string2, notification);
            Storage.this.initialize(insert);
            return insert;
        }

        public List list(String string2) throws IOException {
            List list = new List(string2);
            Storage.this.initialize(list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<org.gradle.internal.impldep.com.google.api.services.storage.model.Notifications> {
            private static final String REST_PATH = "b/{bucket}/notificationConfigs";
            @Key
            private String bucket;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected List(String string2) {
                super(Storage.this, "GET", REST_PATH, (Object)null, org.gradle.internal.impldep.com.google.api.services.storage.model.Notifications.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string2) {
                return (List)super.setAlt(string2);
            }

            public List setFields(String string2) {
                return (List)super.setFields(string2);
            }

            public List setKey(String string2) {
                return (List)super.setKey(string2);
            }

            public List setOauthToken(String string2) {
                return (List)super.setOauthToken(string2);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string2) {
                return (List)super.setQuotaUser(string2);
            }

            public List setUserIp(String string2) {
                return (List)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public List setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public List setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public List set(String string2, Object object) {
                return (List)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<Notification> {
            private static final String REST_PATH = "b/{bucket}/notificationConfigs";
            @Key
            private String bucket;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Insert(String string2, Notification notification) {
                super(Storage.this, "POST", REST_PATH, (Object)notification, Notification.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.checkRequiredParameter(notification, "content");
                this.checkRequiredParameter(notification.getPayloadFormat(), "Notification.getPayloadFormat()");
                this.checkRequiredParameter(notification, "content");
                this.checkRequiredParameter(notification.getTopic(), "Notification.getTopic()");
            }

            public Insert setAlt(String string2) {
                return (Insert)super.setAlt(string2);
            }

            public Insert setFields(String string2) {
                return (Insert)super.setFields(string2);
            }

            public Insert setKey(String string2) {
                return (Insert)super.setKey(string2);
            }

            public Insert setOauthToken(String string2) {
                return (Insert)super.setOauthToken(string2);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string2) {
                return (Insert)super.setQuotaUser(string2);
            }

            public Insert setUserIp(String string2) {
                return (Insert)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Insert setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Insert setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Insert set(String string2, Object object) {
                return (Insert)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<Notification> {
            private static final String REST_PATH = "b/{bucket}/notificationConfigs/{notification}";
            @Key
            private String bucket;
            @Key
            private String notification;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Get(String string2, String string3) {
                super(Storage.this, "GET", REST_PATH, (Object)null, Notification.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.notification = Preconditions.checkNotNull(string3, "Required parameter notification must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string2) {
                return (Get)super.setAlt(string2);
            }

            public Get setFields(String string2) {
                return (Get)super.setFields(string2);
            }

            public Get setKey(String string2) {
                return (Get)super.setKey(string2);
            }

            public Get setOauthToken(String string2) {
                return (Get)super.setOauthToken(string2);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string2) {
                return (Get)super.setQuotaUser(string2);
            }

            public Get setUserIp(String string2) {
                return (Get)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getNotification() {
                return this.notification;
            }

            public Get setNotification(String string2) {
                this.notification = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Get setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Get setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Get set(String string2, Object object) {
                return (Get)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/notificationConfigs/{notification}";
            @Key
            private String bucket;
            @Key
            private String notification;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Delete(String string2, String string3) {
                super(Storage.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.notification = Preconditions.checkNotNull(string3, "Required parameter notification must be specified.");
            }

            public Delete setAlt(String string2) {
                return (Delete)super.setAlt(string2);
            }

            public Delete setFields(String string2) {
                return (Delete)super.setFields(string2);
            }

            public Delete setKey(String string2) {
                return (Delete)super.setKey(string2);
            }

            public Delete setOauthToken(String string2) {
                return (Delete)super.setOauthToken(string2);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string2) {
                return (Delete)super.setQuotaUser(string2);
            }

            public Delete setUserIp(String string2) {
                return (Delete)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getNotification() {
                return this.notification;
            }

            public Delete setNotification(String string2) {
                this.notification = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Delete setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Delete setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Delete set(String string2, Object object) {
                return (Delete)super.set(string2, object);
            }
        }
    }

    public class DefaultObjectAccessControls {
        public Delete delete(String string2, String string3) throws IOException {
            Delete delete = new Delete(string2, string3);
            Storage.this.initialize(delete);
            return delete;
        }

        public Get get(String string2, String string3) throws IOException {
            Get get = new Get(string2, string3);
            Storage.this.initialize(get);
            return get;
        }

        public Insert insert(String string2, ObjectAccessControl objectAccessControl) throws IOException {
            Insert insert = new Insert(string2, objectAccessControl);
            Storage.this.initialize(insert);
            return insert;
        }

        public List list(String string2) throws IOException {
            List list = new List(string2);
            Storage.this.initialize(list);
            return list;
        }

        public Patch patch(String string2, String string3, ObjectAccessControl objectAccessControl) throws IOException {
            Patch patch = new Patch(string2, string3, objectAccessControl);
            Storage.this.initialize(patch);
            return patch;
        }

        public Update update(String string2, String string3, ObjectAccessControl objectAccessControl) throws IOException {
            Update update = new Update(string2, string3, objectAccessControl);
            Storage.this.initialize(update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Update(String string2, String string3, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "PUT", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.entity = Preconditions.checkNotNull(string3, "Required parameter entity must be specified.");
            }

            public Update setAlt(String string2) {
                return (Update)super.setAlt(string2);
            }

            public Update setFields(String string2) {
                return (Update)super.setFields(string2);
            }

            public Update setKey(String string2) {
                return (Update)super.setKey(string2);
            }

            public Update setOauthToken(String string2) {
                return (Update)super.setOauthToken(string2);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string2) {
                return (Update)super.setQuotaUser(string2);
            }

            public Update setUserIp(String string2) {
                return (Update)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Update setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Update setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Update set(String string2, Object object) {
                return (Update)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Patch(String string2, String string3, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "PATCH", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.entity = Preconditions.checkNotNull(string3, "Required parameter entity must be specified.");
            }

            public Patch setAlt(String string2) {
                return (Patch)super.setAlt(string2);
            }

            public Patch setFields(String string2) {
                return (Patch)super.setFields(string2);
            }

            public Patch setKey(String string2) {
                return (Patch)super.setKey(string2);
            }

            public Patch setOauthToken(String string2) {
                return (Patch)super.setOauthToken(string2);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string2) {
                return (Patch)super.setQuotaUser(string2);
            }

            public Patch setUserIp(String string2) {
                return (Patch)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Patch setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Patch setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Patch set(String string2, Object object) {
                return (Patch)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<org.gradle.internal.impldep.com.google.api.services.storage.model.ObjectAccessControls> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected List(String string2) {
                super(Storage.this, "GET", REST_PATH, (Object)null, org.gradle.internal.impldep.com.google.api.services.storage.model.ObjectAccessControls.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string2) {
                return (List)super.setAlt(string2);
            }

            public List setFields(String string2) {
                return (List)super.setFields(string2);
            }

            public List setKey(String string2) {
                return (List)super.setKey(string2);
            }

            public List setOauthToken(String string2) {
                return (List)super.setOauthToken(string2);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string2) {
                return (List)super.setQuotaUser(string2);
            }

            public List setUserIp(String string2) {
                return (List)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public List setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public List setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public List setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public List setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public List set(String string2, Object object) {
                return (List)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl";
            @Key
            private String bucket;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Insert(String string2, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "POST", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.checkRequiredParameter(objectAccessControl, "content");
                this.checkRequiredParameter(objectAccessControl.getEntity(), "ObjectAccessControl.getEntity()");
                this.checkRequiredParameter(objectAccessControl, "content");
                this.checkRequiredParameter(objectAccessControl.getRole(), "ObjectAccessControl.getRole()");
            }

            public Insert setAlt(String string2) {
                return (Insert)super.setAlt(string2);
            }

            public Insert setFields(String string2) {
                return (Insert)super.setFields(string2);
            }

            public Insert setKey(String string2) {
                return (Insert)super.setKey(string2);
            }

            public Insert setOauthToken(String string2) {
                return (Insert)super.setOauthToken(string2);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string2) {
                return (Insert)super.setQuotaUser(string2);
            }

            public Insert setUserIp(String string2) {
                return (Insert)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Insert setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Insert setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Insert set(String string2, Object object) {
                return (Insert)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Get(String string2, String string3) {
                super(Storage.this, "GET", REST_PATH, (Object)null, ObjectAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.entity = Preconditions.checkNotNull(string3, "Required parameter entity must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string2) {
                return (Get)super.setAlt(string2);
            }

            public Get setFields(String string2) {
                return (Get)super.setFields(string2);
            }

            public Get setKey(String string2) {
                return (Get)super.setKey(string2);
            }

            public Get setOauthToken(String string2) {
                return (Get)super.setOauthToken(string2);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string2) {
                return (Get)super.setQuotaUser(string2);
            }

            public Get setUserIp(String string2) {
                return (Get)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Get setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Get setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Get set(String string2, Object object) {
                return (Get)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Delete(String string2, String string3) {
                super(Storage.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.entity = Preconditions.checkNotNull(string3, "Required parameter entity must be specified.");
            }

            public Delete setAlt(String string2) {
                return (Delete)super.setAlt(string2);
            }

            public Delete setFields(String string2) {
                return (Delete)super.setFields(string2);
            }

            public Delete setKey(String string2) {
                return (Delete)super.setKey(string2);
            }

            public Delete setOauthToken(String string2) {
                return (Delete)super.setOauthToken(string2);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string2) {
                return (Delete)super.setQuotaUser(string2);
            }

            public Delete setUserIp(String string2) {
                return (Delete)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Delete setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Delete setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Delete set(String string2, Object object) {
                return (Delete)super.set(string2, object);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel channel) throws IOException {
            Stop stop = new Stop(channel);
            Storage.this.initialize(stop);
            return stop;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Stop
        extends StorageRequest<Void> {
            private static final String REST_PATH = "channels/stop";

            protected Stop(Channel channel) {
                super(Storage.this, "POST", REST_PATH, (Object)channel, Void.class);
            }

            public Stop setAlt(String string2) {
                return (Stop)super.setAlt(string2);
            }

            public Stop setFields(String string2) {
                return (Stop)super.setFields(string2);
            }

            public Stop setKey(String string2) {
                return (Stop)super.setKey(string2);
            }

            public Stop setOauthToken(String string2) {
                return (Stop)super.setOauthToken(string2);
            }

            public Stop setPrettyPrint(Boolean bl) {
                return (Stop)super.setPrettyPrint(bl);
            }

            public Stop setQuotaUser(String string2) {
                return (Stop)super.setQuotaUser(string2);
            }

            public Stop setUserIp(String string2) {
                return (Stop)super.setUserIp(string2);
            }

            @Override
            public Stop set(String string2, Object object) {
                return (Stop)super.set(string2, object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Buckets {
        public Delete delete(String string2) throws IOException {
            Delete delete = new Delete(string2);
            Storage.this.initialize(delete);
            return delete;
        }

        public Get get(String string2) throws IOException {
            Get get = new Get(string2);
            Storage.this.initialize(get);
            return get;
        }

        public GetIamPolicy getIamPolicy(String string2) throws IOException {
            GetIamPolicy getIamPolicy = new GetIamPolicy(string2);
            Storage.this.initialize(getIamPolicy);
            return getIamPolicy;
        }

        public Insert insert(String string2, Bucket bucket) throws IOException {
            Insert insert = new Insert(string2, bucket);
            Storage.this.initialize(insert);
            return insert;
        }

        public List list(String string2) throws IOException {
            List list = new List(string2);
            Storage.this.initialize(list);
            return list;
        }

        public LockRetentionPolicy lockRetentionPolicy(String string2, Long l) throws IOException {
            LockRetentionPolicy lockRetentionPolicy = new LockRetentionPolicy(string2, l);
            Storage.this.initialize(lockRetentionPolicy);
            return lockRetentionPolicy;
        }

        public Patch patch(String string2, Bucket bucket) throws IOException {
            Patch patch = new Patch(string2, bucket);
            Storage.this.initialize(patch);
            return patch;
        }

        public SetIamPolicy setIamPolicy(String string2, Policy policy) throws IOException {
            SetIamPolicy setIamPolicy = new SetIamPolicy(string2, policy);
            Storage.this.initialize(setIamPolicy);
            return setIamPolicy;
        }

        public TestIamPermissions testIamPermissions(String string2, java.util.List<String> list) throws IOException {
            TestIamPermissions testIamPermissions = new TestIamPermissions(string2, list);
            Storage.this.initialize(testIamPermissions);
            return testIamPermissions;
        }

        public Update update(String string2, Bucket bucket) throws IOException {
            Update update = new Update(string2, bucket);
            Storage.this.initialize(update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String predefinedAcl;
            @Key
            private String predefinedDefaultObjectAcl;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Update(String string2, Bucket bucket) {
                super(Storage.this, "PUT", REST_PATH, (Object)bucket, Bucket.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            public Update setAlt(String string2) {
                return (Update)super.setAlt(string2);
            }

            public Update setFields(String string2) {
                return (Update)super.setFields(string2);
            }

            public Update setKey(String string2) {
                return (Update)super.setKey(string2);
            }

            public Update setOauthToken(String string2) {
                return (Update)super.setOauthToken(string2);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string2) {
                return (Update)super.setQuotaUser(string2);
            }

            public Update setUserIp(String string2) {
                return (Update)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Update setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Update setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Update setPredefinedAcl(String string2) {
                this.predefinedAcl = string2;
                return this;
            }

            public String getPredefinedDefaultObjectAcl() {
                return this.predefinedDefaultObjectAcl;
            }

            public Update setPredefinedDefaultObjectAcl(String string2) {
                this.predefinedDefaultObjectAcl = string2;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Update setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Update setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Update set(String string2, Object object) {
                return (Update)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TestIamPermissions
        extends StorageRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "b/{bucket}/iam/testPermissions";
            @Key
            private String bucket;
            @Key
            private java.util.List<String> permissions;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected TestIamPermissions(String string2, java.util.List<String> list) {
                super(Storage.this, "GET", REST_PATH, (Object)null, TestIamPermissionsResponse.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.permissions = Preconditions.checkNotNull(list, "Required parameter permissions must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public TestIamPermissions setAlt(String string2) {
                return (TestIamPermissions)super.setAlt(string2);
            }

            public TestIamPermissions setFields(String string2) {
                return (TestIamPermissions)super.setFields(string2);
            }

            public TestIamPermissions setKey(String string2) {
                return (TestIamPermissions)super.setKey(string2);
            }

            public TestIamPermissions setOauthToken(String string2) {
                return (TestIamPermissions)super.setOauthToken(string2);
            }

            public TestIamPermissions setPrettyPrint(Boolean bl) {
                return (TestIamPermissions)super.setPrettyPrint(bl);
            }

            public TestIamPermissions setQuotaUser(String string2) {
                return (TestIamPermissions)super.setQuotaUser(string2);
            }

            public TestIamPermissions setUserIp(String string2) {
                return (TestIamPermissions)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public TestIamPermissions setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public java.util.List<String> getPermissions() {
                return this.permissions;
            }

            public TestIamPermissions setPermissions(java.util.List<String> list) {
                this.permissions = list;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public TestIamPermissions setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public TestIamPermissions setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public TestIamPermissions set(String string2, Object object) {
                return (TestIamPermissions)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetIamPolicy
        extends StorageRequest<Policy> {
            private static final String REST_PATH = "b/{bucket}/iam";
            @Key
            private String bucket;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected SetIamPolicy(String string2, Policy policy) {
                super(Storage.this, "PUT", REST_PATH, (Object)policy, Policy.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            public SetIamPolicy setAlt(String string2) {
                return (SetIamPolicy)super.setAlt(string2);
            }

            public SetIamPolicy setFields(String string2) {
                return (SetIamPolicy)super.setFields(string2);
            }

            public SetIamPolicy setKey(String string2) {
                return (SetIamPolicy)super.setKey(string2);
            }

            public SetIamPolicy setOauthToken(String string2) {
                return (SetIamPolicy)super.setOauthToken(string2);
            }

            public SetIamPolicy setPrettyPrint(Boolean bl) {
                return (SetIamPolicy)super.setPrettyPrint(bl);
            }

            public SetIamPolicy setQuotaUser(String string2) {
                return (SetIamPolicy)super.setQuotaUser(string2);
            }

            public SetIamPolicy setUserIp(String string2) {
                return (SetIamPolicy)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public SetIamPolicy setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public SetIamPolicy setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public SetIamPolicy setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public SetIamPolicy set(String string2, Object object) {
                return (SetIamPolicy)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String predefinedAcl;
            @Key
            private String predefinedDefaultObjectAcl;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Patch(String string2, Bucket bucket) {
                super(Storage.this, "PATCH", REST_PATH, (Object)bucket, Bucket.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            public Patch setAlt(String string2) {
                return (Patch)super.setAlt(string2);
            }

            public Patch setFields(String string2) {
                return (Patch)super.setFields(string2);
            }

            public Patch setKey(String string2) {
                return (Patch)super.setKey(string2);
            }

            public Patch setOauthToken(String string2) {
                return (Patch)super.setOauthToken(string2);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string2) {
                return (Patch)super.setQuotaUser(string2);
            }

            public Patch setUserIp(String string2) {
                return (Patch)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Patch setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Patch setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Patch setPredefinedAcl(String string2) {
                this.predefinedAcl = string2;
                return this;
            }

            public String getPredefinedDefaultObjectAcl() {
                return this.predefinedDefaultObjectAcl;
            }

            public Patch setPredefinedDefaultObjectAcl(String string2) {
                this.predefinedDefaultObjectAcl = string2;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Patch setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Patch setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Patch set(String string2, Object object) {
                return (Patch)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class LockRetentionPolicy
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}/lockRetentionPolicy";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected LockRetentionPolicy(String string2, Long l) {
                super(Storage.this, "POST", REST_PATH, (Object)null, Bucket.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.ifMetagenerationMatch = Preconditions.checkNotNull(l, "Required parameter ifMetagenerationMatch must be specified.");
            }

            public LockRetentionPolicy setAlt(String string2) {
                return (LockRetentionPolicy)super.setAlt(string2);
            }

            public LockRetentionPolicy setFields(String string2) {
                return (LockRetentionPolicy)super.setFields(string2);
            }

            public LockRetentionPolicy setKey(String string2) {
                return (LockRetentionPolicy)super.setKey(string2);
            }

            public LockRetentionPolicy setOauthToken(String string2) {
                return (LockRetentionPolicy)super.setOauthToken(string2);
            }

            public LockRetentionPolicy setPrettyPrint(Boolean bl) {
                return (LockRetentionPolicy)super.setPrettyPrint(bl);
            }

            public LockRetentionPolicy setQuotaUser(String string2) {
                return (LockRetentionPolicy)super.setQuotaUser(string2);
            }

            public LockRetentionPolicy setUserIp(String string2) {
                return (LockRetentionPolicy)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public LockRetentionPolicy setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public LockRetentionPolicy setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public LockRetentionPolicy setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public LockRetentionPolicy setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public LockRetentionPolicy set(String string2, Object object) {
                return (LockRetentionPolicy)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<org.gradle.internal.impldep.com.google.api.services.storage.model.Buckets> {
            private static final String REST_PATH = "b";
            @Key
            private String project;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String prefix;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected List(String string2) {
                super(Storage.this, "GET", REST_PATH, (Object)null, org.gradle.internal.impldep.com.google.api.services.storage.model.Buckets.class);
                this.project = Preconditions.checkNotNull(string2, "Required parameter project must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string2) {
                return (List)super.setAlt(string2);
            }

            public List setFields(String string2) {
                return (List)super.setFields(string2);
            }

            public List setKey(String string2) {
                return (List)super.setKey(string2);
            }

            public List setOauthToken(String string2) {
                return (List)super.setOauthToken(string2);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string2) {
                return (List)super.setQuotaUser(string2);
            }

            public List setUserIp(String string2) {
                return (List)super.setUserIp(string2);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string2) {
                this.project = string2;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string2) {
                this.pageToken = string2;
                return this;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public List setPrefix(String string2) {
                this.prefix = string2;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public List setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public List setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public List set(String string2, Object object) {
                return (List)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b";
            @Key
            private String project;
            @Key
            private String predefinedAcl;
            @Key
            private String predefinedDefaultObjectAcl;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Insert(String string2, Bucket bucket) {
                super(Storage.this, "POST", REST_PATH, (Object)bucket, Bucket.class);
                this.project = Preconditions.checkNotNull(string2, "Required parameter project must be specified.");
                this.checkRequiredParameter(bucket, "content");
                this.checkRequiredParameter(bucket.getName(), "Bucket.getName()");
            }

            public Insert setAlt(String string2) {
                return (Insert)super.setAlt(string2);
            }

            public Insert setFields(String string2) {
                return (Insert)super.setFields(string2);
            }

            public Insert setKey(String string2) {
                return (Insert)super.setKey(string2);
            }

            public Insert setOauthToken(String string2) {
                return (Insert)super.setOauthToken(string2);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string2) {
                return (Insert)super.setQuotaUser(string2);
            }

            public Insert setUserIp(String string2) {
                return (Insert)super.setUserIp(string2);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string2) {
                this.project = string2;
                return this;
            }

            public String getPredefinedAcl() {
                return this.predefinedAcl;
            }

            public Insert setPredefinedAcl(String string2) {
                this.predefinedAcl = string2;
                return this;
            }

            public String getPredefinedDefaultObjectAcl() {
                return this.predefinedDefaultObjectAcl;
            }

            public Insert setPredefinedDefaultObjectAcl(String string2) {
                this.predefinedDefaultObjectAcl = string2;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Insert setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Insert setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Insert setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Insert set(String string2, Object object) {
                return (Insert)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIamPolicy
        extends StorageRequest<Policy> {
            private static final String REST_PATH = "b/{bucket}/iam";
            @Key
            private String bucket;
            @Key
            private Integer optionsRequestedPolicyVersion;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected GetIamPolicy(String string2) {
                super(Storage.this, "GET", REST_PATH, (Object)null, Policy.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIamPolicy setAlt(String string2) {
                return (GetIamPolicy)super.setAlt(string2);
            }

            public GetIamPolicy setFields(String string2) {
                return (GetIamPolicy)super.setFields(string2);
            }

            public GetIamPolicy setKey(String string2) {
                return (GetIamPolicy)super.setKey(string2);
            }

            public GetIamPolicy setOauthToken(String string2) {
                return (GetIamPolicy)super.setOauthToken(string2);
            }

            public GetIamPolicy setPrettyPrint(Boolean bl) {
                return (GetIamPolicy)super.setPrettyPrint(bl);
            }

            public GetIamPolicy setQuotaUser(String string2) {
                return (GetIamPolicy)super.setQuotaUser(string2);
            }

            public GetIamPolicy setUserIp(String string2) {
                return (GetIamPolicy)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public GetIamPolicy setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public Integer getOptionsRequestedPolicyVersion() {
                return this.optionsRequestedPolicyVersion;
            }

            public GetIamPolicy setOptionsRequestedPolicyVersion(Integer n) {
                this.optionsRequestedPolicyVersion = n;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public GetIamPolicy setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public GetIamPolicy setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public GetIamPolicy set(String string2, Object object) {
                return (GetIamPolicy)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String projection;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Get(String string2) {
                super(Storage.this, "GET", REST_PATH, (Object)null, Bucket.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string2) {
                return (Get)super.setAlt(string2);
            }

            public Get setFields(String string2) {
                return (Get)super.setFields(string2);
            }

            public Get setKey(String string2) {
                return (Get)super.setKey(string2);
            }

            public Get setOauthToken(String string2) {
                return (Get)super.setOauthToken(string2);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string2) {
                return (Get)super.setQuotaUser(string2);
            }

            public Get setUserIp(String string2) {
                return (Get)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Get setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Get setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string2) {
                this.projection = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Get setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Get setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Get set(String string2, Object object) {
                return (Get)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private Long ifMetagenerationMatch;
            @Key
            private Long ifMetagenerationNotMatch;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Delete(String string2) {
                super(Storage.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            public Delete setAlt(String string2) {
                return (Delete)super.setAlt(string2);
            }

            public Delete setFields(String string2) {
                return (Delete)super.setFields(string2);
            }

            public Delete setKey(String string2) {
                return (Delete)super.setKey(string2);
            }

            public Delete setOauthToken(String string2) {
                return (Delete)super.setOauthToken(string2);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string2) {
                return (Delete)super.setQuotaUser(string2);
            }

            public Delete setUserIp(String string2) {
                return (Delete)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public Long getIfMetagenerationMatch() {
                return this.ifMetagenerationMatch;
            }

            public Delete setIfMetagenerationMatch(Long l) {
                this.ifMetagenerationMatch = l;
                return this;
            }

            public Long getIfMetagenerationNotMatch() {
                return this.ifMetagenerationNotMatch;
            }

            public Delete setIfMetagenerationNotMatch(Long l) {
                this.ifMetagenerationNotMatch = l;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Delete setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Delete setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Delete set(String string2, Object object) {
                return (Delete)super.set(string2, object);
            }
        }
    }

    public class BucketAccessControls {
        public Delete delete(String string2, String string3) throws IOException {
            Delete delete = new Delete(string2, string3);
            Storage.this.initialize(delete);
            return delete;
        }

        public Get get(String string2, String string3) throws IOException {
            Get get = new Get(string2, string3);
            Storage.this.initialize(get);
            return get;
        }

        public Insert insert(String string2, BucketAccessControl bucketAccessControl) throws IOException {
            Insert insert = new Insert(string2, bucketAccessControl);
            Storage.this.initialize(insert);
            return insert;
        }

        public List list(String string2) throws IOException {
            List list = new List(string2);
            Storage.this.initialize(list);
            return list;
        }

        public Patch patch(String string2, String string3, BucketAccessControl bucketAccessControl) throws IOException {
            Patch patch = new Patch(string2, string3, bucketAccessControl);
            Storage.this.initialize(patch);
            return patch;
        }

        public Update update(String string2, String string3, BucketAccessControl bucketAccessControl) throws IOException {
            Update update = new Update(string2, string3, bucketAccessControl);
            Storage.this.initialize(update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Update(String string2, String string3, BucketAccessControl bucketAccessControl) {
                super(Storage.this, "PUT", REST_PATH, (Object)bucketAccessControl, BucketAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.entity = Preconditions.checkNotNull(string3, "Required parameter entity must be specified.");
            }

            public Update setAlt(String string2) {
                return (Update)super.setAlt(string2);
            }

            public Update setFields(String string2) {
                return (Update)super.setFields(string2);
            }

            public Update setKey(String string2) {
                return (Update)super.setKey(string2);
            }

            public Update setOauthToken(String string2) {
                return (Update)super.setOauthToken(string2);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string2) {
                return (Update)super.setQuotaUser(string2);
            }

            public Update setUserIp(String string2) {
                return (Update)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Update setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Update setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Update set(String string2, Object object) {
                return (Update)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Patch(String string2, String string3, BucketAccessControl bucketAccessControl) {
                super(Storage.this, "PATCH", REST_PATH, (Object)bucketAccessControl, BucketAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.entity = Preconditions.checkNotNull(string3, "Required parameter entity must be specified.");
            }

            public Patch setAlt(String string2) {
                return (Patch)super.setAlt(string2);
            }

            public Patch setFields(String string2) {
                return (Patch)super.setFields(string2);
            }

            public Patch setKey(String string2) {
                return (Patch)super.setKey(string2);
            }

            public Patch setOauthToken(String string2) {
                return (Patch)super.setOauthToken(string2);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string2) {
                return (Patch)super.setQuotaUser(string2);
            }

            public Patch setUserIp(String string2) {
                return (Patch)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Patch setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Patch setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Patch set(String string2, Object object) {
                return (Patch)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<org.gradle.internal.impldep.com.google.api.services.storage.model.BucketAccessControls> {
            private static final String REST_PATH = "b/{bucket}/acl";
            @Key
            private String bucket;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected List(String string2) {
                super(Storage.this, "GET", REST_PATH, (Object)null, org.gradle.internal.impldep.com.google.api.services.storage.model.BucketAccessControls.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string2) {
                return (List)super.setAlt(string2);
            }

            public List setFields(String string2) {
                return (List)super.setFields(string2);
            }

            public List setKey(String string2) {
                return (List)super.setKey(string2);
            }

            public List setOauthToken(String string2) {
                return (List)super.setOauthToken(string2);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string2) {
                return (List)super.setQuotaUser(string2);
            }

            public List setUserIp(String string2) {
                return (List)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public List setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public List setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public List set(String string2, Object object) {
                return (List)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl";
            @Key
            private String bucket;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Insert(String string2, BucketAccessControl bucketAccessControl) {
                super(Storage.this, "POST", REST_PATH, (Object)bucketAccessControl, BucketAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.checkRequiredParameter(bucketAccessControl, "content");
                this.checkRequiredParameter(bucketAccessControl.getEntity(), "BucketAccessControl.getEntity()");
                this.checkRequiredParameter(bucketAccessControl, "content");
                this.checkRequiredParameter(bucketAccessControl.getRole(), "BucketAccessControl.getRole()");
            }

            public Insert setAlt(String string2) {
                return (Insert)super.setAlt(string2);
            }

            public Insert setFields(String string2) {
                return (Insert)super.setFields(string2);
            }

            public Insert setKey(String string2) {
                return (Insert)super.setKey(string2);
            }

            public Insert setOauthToken(String string2) {
                return (Insert)super.setOauthToken(string2);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string2) {
                return (Insert)super.setQuotaUser(string2);
            }

            public Insert setUserIp(String string2) {
                return (Insert)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Insert setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Insert setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Insert set(String string2, Object object) {
                return (Insert)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Get(String string2, String string3) {
                super(Storage.this, "GET", REST_PATH, (Object)null, BucketAccessControl.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.entity = Preconditions.checkNotNull(string3, "Required parameter entity must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string2) {
                return (Get)super.setAlt(string2);
            }

            public Get setFields(String string2) {
                return (Get)super.setFields(string2);
            }

            public Get setKey(String string2) {
                return (Get)super.setKey(string2);
            }

            public Get setOauthToken(String string2) {
                return (Get)super.setOauthToken(string2);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string2) {
                return (Get)super.setQuotaUser(string2);
            }

            public Get setUserIp(String string2) {
                return (Get)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Get setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Get setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Get set(String string2, Object object) {
                return (Get)super.set(string2, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;
            @Key
            private String provisionalUserProject;
            @Key
            private String userProject;

            protected Delete(String string2, String string3) {
                super(Storage.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.bucket = Preconditions.checkNotNull(string2, "Required parameter bucket must be specified.");
                this.entity = Preconditions.checkNotNull(string3, "Required parameter entity must be specified.");
            }

            public Delete setAlt(String string2) {
                return (Delete)super.setAlt(string2);
            }

            public Delete setFields(String string2) {
                return (Delete)super.setFields(string2);
            }

            public Delete setKey(String string2) {
                return (Delete)super.setKey(string2);
            }

            public Delete setOauthToken(String string2) {
                return (Delete)super.setOauthToken(string2);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string2) {
                return (Delete)super.setQuotaUser(string2);
            }

            public Delete setUserIp(String string2) {
                return (Delete)super.setUserIp(string2);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string2) {
                this.bucket = string2;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String string2) {
                this.entity = string2;
                return this;
            }

            public String getProvisionalUserProject() {
                return this.provisionalUserProject;
            }

            public Delete setProvisionalUserProject(String string2) {
                this.provisionalUserProject = string2;
                return this;
            }

            public String getUserProject() {
                return this.userProject;
            }

            public Delete setUserProject(String string2) {
                this.userProject = string2;
                return this;
            }

            @Override
            public Delete set(String string2, Object object) {
                return (Delete)super.set(string2, object);
            }
        }
    }
}

