/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.thoughtworks.qdox.junit;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.gradle.internal.impldep.com.thoughtworks.qdox.JavaDocBuilder;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.AbstractJavaEntity;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.JavaClass;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.JavaField;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.JavaMethod;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.JavaSource;
import org.gradle.internal.impldep.com.thoughtworks.qdox.model.Type;
import org.gradle.internal.impldep.junit.framework.TestCase;

public abstract class APITestCase
extends TestCase {
    private static Comparator ENTITY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            AbstractBaseJavaEntity entity1 = (AbstractBaseJavaEntity)o1;
            AbstractBaseJavaEntity entity2 = (AbstractBaseJavaEntity)o2;
            return entity1.getName().compareTo(entity2.getName());
        }
    };

    public static void assertApiEquals(URL expected, URL actual) throws IOException {
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSource(new InputStreamReader(expected.openStream()), expected.toExternalForm());
        builder.addSource(new InputStreamReader(actual.openStream()), actual.toExternalForm());
        JavaSource expectedSource = builder.getSources()[0];
        JavaSource actualsource = builder.getSources()[1];
        APITestCase.assertApiEquals(expectedSource, actualsource);
    }

    private static void assertApiEquals(JavaSource expected, JavaSource actual) {
        List<JavaClass> expectedClasses = Arrays.asList(expected.getClasses());
        Collections.sort(expectedClasses, ENTITY_COMPARATOR);
        List<JavaClass> actualClasses = Arrays.asList(actual.getClasses());
        Collections.sort(actualClasses, ENTITY_COMPARATOR);
        APITestCase.assertEquals("Number of classes should be equal", expectedClasses.size(), actualClasses.size());
        for (int i = 0; i < expectedClasses.size(); ++i) {
            APITestCase.assertClassesEqual(expectedClasses.get(i), actualClasses.get(i));
        }
    }

    private static void assertClassesEqual(JavaClass expected, JavaClass actual) {
        APITestCase.assertEquals("Package names should be equal", expected.getPackage(), actual.getPackage());
        APITestCase.assertModifiersEquals("Class modifiers should be equal", expected, actual);
        APITestCase.assertEquals("Class names should be equal", expected.getName(), actual.getName());
        if (expected.getSuperJavaClass() != null && actual.getSuperJavaClass() != null) {
            APITestCase.assertEquals("Super class should be equal", expected.getSuperJavaClass().getName(), actual.getSuperJavaClass().getName());
        }
        if (expected.getSuperJavaClass() == null ^ actual.getSuperJavaClass() == null) {
            APITestCase.fail("Super class should be equal");
        }
        APITestCase.assertInterfacesEqual(expected, actual);
        APITestCase.assertInnerClassesEquals(expected, actual);
        APITestCase.assertFieldsEqual(expected, actual);
        APITestCase.assertMethodsEqual(expected, actual);
    }

    private static void assertFieldEquals(JavaField expected, JavaField actual) {
        StringBuffer message2 = new StringBuffer("-> assertFieldEquals");
        message2.append("\n\tExcepted : ");
        message2.append(expected);
        message2.append("\n\tActual : ");
        message2.append(actual);
        message2.append("\n");
        APITestCase.assertEquals(message2.toString() + "Field types should be equal", expected.getType(), actual.getType());
        APITestCase.assertEquals(message2.toString() + "Field names should be equal", expected.getName(), actual.getName());
        APITestCase.assertModifiersEquals(message2.toString() + "Field modifiers should be equal", expected, actual);
    }

    private static void assertFieldsEqual(JavaClass expected, JavaClass actual) {
        List<JavaField> expectedFields = Arrays.asList(expected.getFields());
        Collections.sort(expectedFields, ENTITY_COMPARATOR);
        List<JavaField> actualFields = Arrays.asList(actual.getFields());
        Collections.sort(actualFields, ENTITY_COMPARATOR);
        StringBuffer message2 = new StringBuffer("-> assertFieldsEqual");
        message2.append("\n\tExcepted : ");
        message2.append(expectedFields);
        message2.append("\n\tActual : ");
        message2.append(actualFields);
        message2.append("\n");
        APITestCase.assertEquals(message2.toString() + "Number of fields should be equal", expectedFields.size(), actualFields.size());
        for (int i = 0; i < expectedFields.size(); ++i) {
            APITestCase.assertFieldEquals(expectedFields.get(i), actualFields.get(i));
        }
    }

    private static void assertInnerClassesEquals(JavaClass expected, JavaClass actual) {
        List<JavaClass> expectedInnerClasses = Arrays.asList(expected.getNestedClasses());
        Collections.sort(expectedInnerClasses, ENTITY_COMPARATOR);
        List<JavaClass> actualInnerClasses = Arrays.asList(actual.getNestedClasses());
        Collections.sort(actualInnerClasses, ENTITY_COMPARATOR);
        StringBuffer message2 = new StringBuffer("-> assertInnerClassesEquals");
        message2.append("\n\tExcepted : ");
        message2.append(expectedInnerClasses);
        message2.append("\n\tActual : ");
        message2.append(actualInnerClasses);
        message2.append("\n");
        APITestCase.assertEquals(message2.toString() + "Number of inner classes should be equal", expectedInnerClasses.size(), actualInnerClasses.size());
        for (int i = 0; i < expectedInnerClasses.size(); ++i) {
            APITestCase.assertClassesEqual(expectedInnerClasses.get(i), actualInnerClasses.get(i));
        }
    }

    private static void assertInterfacesEqual(JavaClass expected, JavaClass actual) {
        List<Type> expectedImplements = Arrays.asList(expected.getImplements());
        Collections.sort(expectedImplements);
        List<Type> actualImplements = Arrays.asList(actual.getImplements());
        Collections.sort(actualImplements);
        StringBuffer message2 = new StringBuffer("-> assertInnerClassesEquals");
        message2.append("\n\tExcepted : ");
        message2.append(expectedImplements);
        message2.append("\n\tActual : ");
        message2.append(actualImplements);
        message2.append("\n");
        APITestCase.assertEquals(message2.toString() + "Number of implemented interface should be equal", expectedImplements.size(), actualImplements.size());
        for (int i = 0; i < expectedImplements.size(); ++i) {
            APITestCase.assertEquals("Implemented interface should be equal", expectedImplements.get(i), actualImplements.get(i));
        }
    }

    private static void assertMethodsEqual(JavaClass expected, JavaClass actual) {
        List<JavaMethod> expectedMethods = Arrays.asList(expected.getMethods());
        Collections.sort(expectedMethods, ENTITY_COMPARATOR);
        List<JavaMethod> actualMethods = Arrays.asList(actual.getMethods());
        Collections.sort(actualMethods, ENTITY_COMPARATOR);
        StringBuffer message2 = new StringBuffer("-> assertMethodsEqual");
        message2.append("\n\tExcepted : ");
        message2.append(expectedMethods);
        message2.append("\n\tActual : ");
        message2.append(actualMethods);
        message2.append("\n");
        APITestCase.assertEquals(message2.toString() + "Number of methods should be equal", expectedMethods.size(), actualMethods.size());
        for (int i = 0; i < expectedMethods.size(); ++i) {
            APITestCase.assertEquals("Method should be equal", expectedMethods.get(i), actualMethods.get(i));
        }
    }

    private static void assertModifiersEquals(String msg, AbstractJavaEntity expected, AbstractJavaEntity actual) {
        List<String> expectedModifiers = Arrays.asList(expected.getModifiers());
        Collections.sort(expectedModifiers);
        List<String> actualModifiers = Arrays.asList(actual.getModifiers());
        Collections.sort(actualModifiers);
        StringBuffer message2 = new StringBuffer("-> assertModifiersEquals");
        message2.append("\n\tExcepted : ");
        message2.append(expectedModifiers);
        message2.append("\n\tActual : ");
        message2.append(actualModifiers);
        message2.append("\n");
        APITestCase.assertEquals(message2.toString() + msg + "\nNumber of modifiers should be equal", expectedModifiers.size(), actualModifiers.size());
        for (int i = 0; i < expectedModifiers.size(); ++i) {
            APITestCase.assertEquals(msg + "\n" + message2.toString() + "\nModifier should be equal", (Object)expectedModifiers.get(i), (Object)actualModifiers.get(i));
        }
    }

    private static void assertNotDir(File expected, File actual) {
        if (expected.isDirectory()) {
            APITestCase.fail(expected.getAbsolutePath() + " - should not have been a directory");
        }
        if (actual.isDirectory()) {
            APITestCase.fail(actual.getAbsolutePath() + " - should not have been a directory");
        }
    }

    protected File getDir() {
        return new File(this.getClass().getResource("/" + this.getClass().getName().replace('.', '/') + ".class").getFile()).getParentFile();
    }

    protected File getRootDir() {
        File dir2 = this.getDir();
        StringTokenizer st = new StringTokenizer(this.getClass().getName(), ".");
        for (int i = 0; i < st.countTokens() - 1; ++i) {
            dir2 = dir2.getParentFile();
        }
        return dir2;
    }
}

