/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.gnu.trove;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.gradle.internal.impldep.gnu.trove.SerializationProcedure;
import org.gradle.internal.impldep.gnu.trove.TDoubleHash;
import org.gradle.internal.impldep.gnu.trove.TDoubleHashingStrategy;
import org.gradle.internal.impldep.gnu.trove.TDoubleIterator;
import org.gradle.internal.impldep.gnu.trove.TDoubleProcedure;

public class TDoubleHashSet
extends TDoubleHash {
    public TDoubleHashSet() {
    }

    public TDoubleHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TDoubleHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TDoubleHashSet(double[] array) {
        this(array.length);
        this.addAll(array);
    }

    public TDoubleHashSet(TDoubleHashingStrategy strategy) {
        super(strategy);
    }

    public TDoubleHashSet(int initialCapacity, TDoubleHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TDoubleHashSet(int initialCapacity, float loadFactor, TDoubleHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TDoubleHashSet(double[] array, TDoubleHashingStrategy strategy) {
        this(array.length, strategy);
        this.addAll(array);
    }

    public TDoubleIterator iterator() {
        return new TDoubleIterator(this);
    }

    public boolean add(double val) {
        int index = this.insertionIndex(val);
        if (index < 0) {
            return false;
        }
        byte previousState = this._states[index];
        this._set[index] = val;
        this._states[index] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        double[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new double[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            double o = oldSet[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._states[index] = 1;
        }
    }

    public double[] toArray() {
        double[] result = new double[this.size()];
        double[] set2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                result[j++] = set2[i];
            }
        }
        return result;
    }

    public void clear() {
        super.clear();
        double[] set2 = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = set2.length;
            while (i-- > 0) {
                set2[i] = 0.0;
                states[i] = 0;
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TDoubleHashSet)) {
            return false;
        }
        final TDoubleHashSet that = (TDoubleHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TDoubleProcedure(){

            public final boolean execute(double value) {
                return that.contains(value);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(double val) {
        int index = this.index(val);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsAll(double[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(double[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(double[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(double[] array) {
        Arrays.sort(array);
        double[] set2 = this._set;
        byte[] states = this._states;
        boolean changed = false;
        if (set2 != null) {
            int i = set2.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array, set2[i]) >= 0) continue;
                this.remove(set2[i]);
                changed = true;
            }
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            double val = stream.readDouble();
            this.add(val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEach(new TDoubleProcedure(){

            public boolean execute(double value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(value);
                return true;
            }
        });
        sb.append(']');
        sb.insert(0, '[');
        return sb.toString();
    }

    private final class HashProcedure
    implements TDoubleProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double key) {
            this.h += TDoubleHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

