/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.http.impl.entity;

import java.io.IOException;
import org.gradle.internal.impldep.org.apache.http.Header;
import org.gradle.internal.impldep.org.apache.http.HttpEntity;
import org.gradle.internal.impldep.org.apache.http.HttpException;
import org.gradle.internal.impldep.org.apache.http.HttpMessage;
import org.gradle.internal.impldep.org.apache.http.annotation.Contract;
import org.gradle.internal.impldep.org.apache.http.annotation.ThreadingBehavior;
import org.gradle.internal.impldep.org.apache.http.entity.BasicHttpEntity;
import org.gradle.internal.impldep.org.apache.http.entity.ContentLengthStrategy;
import org.gradle.internal.impldep.org.apache.http.impl.io.ChunkedInputStream;
import org.gradle.internal.impldep.org.apache.http.impl.io.ContentLengthInputStream;
import org.gradle.internal.impldep.org.apache.http.impl.io.IdentityInputStream;
import org.gradle.internal.impldep.org.apache.http.io.SessionInputBuffer;
import org.gradle.internal.impldep.org.apache.http.util.Args;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inBuffer, HttpMessage message2) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message2);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inBuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inBuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inBuffer, len));
        }
        Header contentTypeHeader = message2.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message2.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inBuffer, HttpMessage message2) throws HttpException, IOException {
        Args.notNull(inBuffer, "Session input buffer");
        Args.notNull(message2, "HTTP message");
        return this.doDeserialize(inBuffer, message2);
    }
}

