/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.gradle.internal.impldep.org.apache.ivy.Ivy;
import org.gradle.internal.impldep.org.apache.ivy.ant.IvyTask;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Artifact;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.Configuration;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.gradle.internal.impldep.org.apache.ivy.core.settings.IvySettings;
import org.gradle.internal.impldep.org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;

public class IvyInfo
extends IvyTask {
    private File file = null;
    private String organisation;
    private String module;
    private String branch;
    private String revision;
    private String property = "ivy";

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String prefix) {
        this.property = prefix;
    }

    public void doExecute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        IvySettings settings = ivy.getSettings();
        try {
            if (this.organisation != null || this.module != null || this.revision != null || this.branch != null) {
                ResolvedModuleRevision rmr;
                if (this.organisation == null) {
                    throw new BuildException("no organisation provided for ivy info task");
                }
                if (this.module == null) {
                    throw new BuildException("no module name provided for ivy info task");
                }
                if (this.revision == null) {
                    throw new BuildException("no revision provided for ivy info task");
                }
                if (this.branch == null) {
                    settings.getDefaultBranch(new ModuleId(this.organisation, this.module));
                }
                if ((rmr = ivy.findModule(ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision))) != null) {
                    ModuleDescriptor md = rmr.getDescriptor();
                    ModuleRevisionId mrid = rmr.getId();
                    this.setProperties(md, mrid);
                }
            } else {
                if (this.file == null) {
                    this.file = this.getProject().resolveFile(this.getProperty(settings, "ivy.dep.file"));
                }
                ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(settings, this.file.toURI().toURL(), this.doValidate(settings));
                ModuleRevisionId mrid = md.getModuleRevisionId();
                this.setProperties(md, mrid);
            }
        }
        catch (MalformedURLException e) {
            throw new BuildException("unable to convert given ivy file to url: " + this.file + ": " + e, e);
        }
        catch (ParseException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file: " + e, e);
        }
        catch (Exception e) {
            throw new BuildException("impossible to resolve dependencies: " + e, e);
        }
    }

    private void setProperties(ModuleDescriptor md, ModuleRevisionId mrid) {
        this.getProject().setProperty(this.property + ".organisation", mrid.getOrganisation());
        this.getProject().setProperty(this.property + ".module", mrid.getName());
        if (mrid.getBranch() != null) {
            this.getProject().setProperty(this.property + ".branch", mrid.getBranch());
        }
        this.getProject().setProperty(this.property + ".revision", mrid.getRevision());
        this.getProject().setProperty(this.property + ".status", md.getStatus());
        if (md.getPublicationDate() != null) {
            this.getProject().setProperty(this.property + ".publication", Long.toString(md.getPublicationDate().getTime()));
        }
        Map extra = mrid.getExtraAttributes();
        Iterator iter = extra.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.getProject().setProperty(this.property + ".extra." + entry.getKey(), (String)entry.getValue());
        }
        this.getProject().setProperty(this.property + ".configurations", this.mergeConfs(md.getConfigurationsNames()));
        Configuration[] configs = md.getConfigurations();
        ArrayList<String> publicConfigsList = new ArrayList<String>();
        for (int i = 0; i < configs.length; ++i) {
            String name = configs[i].getName();
            if (Configuration.Visibility.PUBLIC.equals(configs[i].getVisibility())) {
                publicConfigsList.add(name);
            }
            if (configs[i].getDescription() == null) continue;
            this.getProject().setProperty(this.property + ".configuration." + name + ".desc", configs[i].getDescription());
        }
        String[] publicConfigs = publicConfigsList.toArray(new String[publicConfigsList.size()]);
        this.getProject().setProperty(this.property + ".public.configurations", this.mergeConfs(publicConfigs));
        Artifact[] artifacts2 = md.getAllArtifacts();
        for (int i = 0; i < artifacts2.length; ++i) {
            int id = i + 1;
            this.getProject().setProperty(this.property + ".artifact." + id + ".name", artifacts2[i].getName());
            this.getProject().setProperty(this.property + ".artifact." + id + ".type", artifacts2[i].getType());
            this.getProject().setProperty(this.property + ".artifact." + id + ".ext", artifacts2[i].getExt());
            this.getProject().setProperty(this.property + ".artifact." + id + ".conf", this.mergeConfs(artifacts2[i].getConfigurations()));
            Map artiExtra = artifacts2[i].getExtraAttributes();
            Iterator iter2 = artiExtra.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                this.getProject().setProperty(this.property + ".artifact." + id + ".extra." + entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

