/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTProcess;
import org.gradle.internal.impldep.org.apache.ivy.Ivy;
import org.gradle.internal.impldep.org.apache.ivy.ant.IvyTask;
import org.gradle.internal.impldep.org.apache.ivy.core.cache.ResolutionCacheManager;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleId;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.internal.impldep.org.apache.ivy.core.report.ResolveReport;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveOptions;
import org.gradle.internal.impldep.org.apache.ivy.core.settings.IvySettings;
import org.gradle.internal.impldep.org.apache.ivy.plugins.report.XmlReportOutputter;
import org.gradle.internal.impldep.org.apache.ivy.util.FileUtil;

public class IvyRepositoryReport
extends IvyTask {
    private String organisation = "*";
    private String module;
    private String branch;
    private String revision = "latest.integration";
    private String matcher = "exactOrRegexp";
    private File todir;
    private boolean graph = false;
    private boolean dot = false;
    private boolean xml = true;
    private boolean xsl = false;
    private String xslFile;
    private String outputname = "ivy-repository-report";
    private String xslext = "html";
    private List params = new ArrayList();

    public void doExecute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        IvySettings settings = ivy.getSettings();
        if (this.xsl && this.xslFile == null) {
            throw new BuildException("xsl file is mandatory when using xsl generation");
        }
        if (this.module == null && "exact".equals(this.matcher)) {
            throw new BuildException("no module name provided for ivy repository graph task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        if (this.module == null && !"exact".equals(this.matcher)) {
            this.module = "*";
        }
        ModuleRevisionId mrid = ModuleRevisionId.newInstance(this.organisation, this.module, this.revision);
        try {
            ModuleRevisionId criteria = null;
            criteria = this.revision == null || settings.getVersionMatcher().isDynamic(mrid) ? new ModuleRevisionId(new ModuleId(this.organisation, this.module), this.branch, "*") : new ModuleRevisionId(new ModuleId(this.organisation, this.module), this.branch, this.revision);
            ModuleRevisionId[] mrids = ivy.listModules(criteria, settings.getMatcher(this.matcher));
            HashSet<ModuleRevisionId> modules = new HashSet<ModuleRevisionId>();
            for (int i = 0; i < mrids.length; ++i) {
                modules.add(ModuleRevisionId.newInstance(mrids[i], this.revision));
            }
            mrids = modules.toArray(new ModuleRevisionId[modules.size()]);
            DefaultModuleDescriptor md = DefaultModuleDescriptor.newCallerInstance(mrids, true, false);
            String resolveId = ResolveOptions.getDefaultResolveId(md);
            ResolveReport report = ivy.resolve(md, new ResolveOptions().setResolveId(resolveId).setValidate(this.doValidate(settings)));
            ResolutionCacheManager cacheMgr = this.getIvyInstance().getResolutionCacheManager();
            new XmlReportOutputter().output(report, cacheMgr, new ResolveOptions());
            if (this.graph) {
                this.gengraph(cacheMgr, md.getModuleRevisionId().getOrganisation(), md.getModuleRevisionId().getName());
            }
            if (this.dot) {
                this.gendot(cacheMgr, md.getModuleRevisionId().getOrganisation(), md.getModuleRevisionId().getName());
            }
            if (this.xml) {
                FileUtil.copy(cacheMgr.getConfigurationResolveReportInCache(resolveId, "default"), new File(this.getTodir(), this.outputname + ".xml"), null);
            }
            if (this.xsl) {
                this.genreport(cacheMgr, md.getModuleRevisionId().getOrganisation(), md.getModuleRevisionId().getName());
            }
        }
        catch (Exception e) {
            throw new BuildException("impossible to generate graph for " + mrid + ": " + e, e);
        }
    }

    private void genreport(ResolutionCacheManager cache2, String organisation, String module) throws IOException {
        XSLTProcess xslt = new XSLTProcess();
        xslt.setTaskName(this.getTaskName());
        xslt.setProject(this.getProject());
        xslt.init();
        String resolveId = ResolveOptions.getDefaultResolveId(new ModuleId(organisation, module));
        xslt.setIn(cache2.getConfigurationResolveReportInCache(resolveId, "default"));
        xslt.setOut(new File(this.getTodir(), this.outputname + "." + this.xslext));
        xslt.setStyle(this.xslFile);
        XSLTProcess.Param param = xslt.createParam();
        param.setName("extension");
        param.setExpression(this.xslext);
        Iterator it = this.params.iterator();
        while (it.hasNext()) {
            param = (XSLTProcess.Param)it.next();
            XSLTProcess.Param realParam = xslt.createParam();
            realParam.setName(param.getName());
            realParam.setExpression(param.getExpression());
        }
        xslt.execute();
    }

    private void gengraph(ResolutionCacheManager cache2, String organisation, String module) throws IOException {
        this.gen(cache2, organisation, module, this.getGraphStylePath(cache2.getResolutionCacheRoot()), "graphml");
    }

    private String getGraphStylePath(File cache2) throws IOException {
        File style = new File(cache2, "ivy-report-graph-all.xsl");
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report-graph-all.xsl"), style, null);
        return style.getAbsolutePath();
    }

    private void gendot(ResolutionCacheManager cache2, String organisation, String module) throws IOException {
        this.gen(cache2, organisation, module, this.getDotStylePath(cache2.getResolutionCacheRoot()), "dot");
    }

    private String getDotStylePath(File cache2) throws IOException {
        File style = new File(cache2, "ivy-report-dot-all.xsl");
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report-dot-all.xsl"), style, null);
        return style.getAbsolutePath();
    }

    private void gen(ResolutionCacheManager cache2, String organisation, String module, String style, String ext) throws IOException {
        XSLTProcess xslt = new XSLTProcess();
        xslt.setTaskName(this.getTaskName());
        xslt.setProject(this.getProject());
        xslt.init();
        String resolveId = ResolveOptions.getDefaultResolveId(new ModuleId(organisation, module));
        xslt.setIn(cache2.getConfigurationResolveReportInCache(resolveId, "default"));
        xslt.setOut(new File(this.getTodir(), this.outputname + "." + ext));
        xslt.setBasedir(cache2.getResolutionCacheRoot());
        xslt.setStyle(style);
        xslt.execute();
    }

    public File getTodir() {
        if (this.todir == null && this.getProject() != null) {
            return this.getProject().getBaseDir();
        }
        return this.todir;
    }

    public void setTodir(File todir) {
        this.todir = todir;
    }

    public boolean isGraph() {
        return this.graph;
    }

    public void setGraph(boolean graph) {
        this.graph = graph;
    }

    public String getXslfile() {
        return this.xslFile;
    }

    public void setXslfile(String xslFile) {
        this.xslFile = xslFile;
    }

    public boolean isXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public boolean isXsl() {
        return this.xsl;
    }

    public void setXsl(boolean xsl) {
        this.xsl = xsl;
    }

    public String getXslext() {
        return this.xslext;
    }

    public void setXslext(String xslext) {
        this.xslext = xslext;
    }

    public XSLTProcess.Param createParam() {
        XSLTProcess.Param result = new XSLTProcess.Param();
        this.params.add(result);
        return result;
    }

    public String getOutputname() {
        return this.outputname;
    }

    public void setOutputname(String outputpattern) {
        this.outputname = outputpattern;
    }

    public void setCache(File cache2) {
        this.cacheAttributeNotSupported();
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String matcher) {
        this.matcher = matcher;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public boolean isDot() {
        return this.dot;
    }

    public void setDot(boolean dot) {
        this.dot = dot;
    }
}

