/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.core;

import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleCapability;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleRequirement;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.ExportPackage;
import org.gradle.internal.impldep.org.apache.ivy.osgi.util.Version;

public class BundleInfo {
    public static final Version DEFAULT_VERSION = new Version(1, 0, 0, null);
    public static final String PACKAGE_TYPE = "package";
    public static final String BUNDLE_TYPE = "bundle";
    public static final String SERVICE_TYPE = "service";
    private String symbolicName;
    private String presentationName;
    private String id;
    private Version version;
    private Set requirements = new LinkedHashSet();
    private Set capabilities = new LinkedHashSet();
    private List executionEnvironments = Collections.EMPTY_LIST;
    private String description;
    private String documentation;
    private String license;
    private Integer size;
    private URI uri;

    public BundleInfo(String name, Version version) {
        this.symbolicName = name;
        this.version = version;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("BundleInfo [executionEnvironments=");
        builder.append(this.executionEnvironments);
        builder.append(", capabilities=");
        builder.append(this.capabilities);
        builder.append(", requirements=");
        builder.append(this.requirements);
        builder.append(", symbolicName=");
        builder.append(this.symbolicName);
        builder.append(", version=");
        builder.append(this.version);
        builder.append("]");
        return builder.toString();
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version == null ? DEFAULT_VERSION : this.version;
    }

    public Version getRawVersion() {
        return this.version;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setPresentationName(String presentationName) {
        this.presentationName = presentationName;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicense() {
        return this.license;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public void addRequirement(BundleRequirement requirement) {
        this.requirements.add(requirement);
    }

    public Set getRequirements() {
        return this.requirements;
    }

    public void addCapability(BundleCapability capability) {
        this.capabilities.add(capability);
    }

    public Set getCapabilities() {
        return this.capabilities;
    }

    public List getExecutionEnvironments() {
        return this.executionEnvironments;
    }

    public void setExecutionEnvironments(List executionEnvironment) {
        this.executionEnvironments = executionEnvironment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capabilities == null ? 0 : ((Object)this.capabilities).hashCode());
        result = 31 * result + (this.requirements == null ? 0 : ((Object)this.requirements).hashCode());
        result = 31 * result + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.executionEnvironments == null ? 0 : ((Object)this.executionEnvironments).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInfo)) {
            return false;
        }
        BundleInfo other = (BundleInfo)obj;
        if (this.capabilities == null ? other.capabilities != null : !((Object)this.capabilities).equals(other.capabilities)) {
            return false;
        }
        if (this.requirements == null ? other.requirements != null : !((Object)this.requirements).equals(other.requirements)) {
            return false;
        }
        if (this.symbolicName == null ? other.symbolicName != null : !this.symbolicName.equals(other.symbolicName)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.executionEnvironments == null ? other.executionEnvironments != null : !((Object)this.executionEnvironments).equals(other.executionEnvironments));
    }

    public Set getRequires() {
        LinkedHashSet<BundleRequirement> set2 = new LinkedHashSet<BundleRequirement>();
        Iterator itRequirements = this.requirements.iterator();
        while (itRequirements.hasNext()) {
            BundleRequirement requirement = (BundleRequirement)itRequirements.next();
            if (!requirement.getType().equals(BUNDLE_TYPE)) continue;
            set2.add(requirement);
        }
        return set2;
    }

    public Set getImports() {
        LinkedHashSet<BundleRequirement> set2 = new LinkedHashSet<BundleRequirement>();
        Iterator itRequirements = this.requirements.iterator();
        while (itRequirements.hasNext()) {
            BundleRequirement requirement = (BundleRequirement)itRequirements.next();
            if (!requirement.getType().equals(PACKAGE_TYPE)) continue;
            set2.add(requirement);
        }
        return set2;
    }

    public Set getExports() {
        LinkedHashSet<ExportPackage> set2 = new LinkedHashSet<ExportPackage>();
        Iterator itCapabilities = this.capabilities.iterator();
        while (itCapabilities.hasNext()) {
            BundleCapability capability = (BundleCapability)itCapabilities.next();
            if (!PACKAGE_TYPE.equals(capability.getType())) continue;
            set2.add((ExportPackage)capability);
        }
        return set2;
    }

    public Set getServices() {
        LinkedHashSet<BundleCapability> set2 = new LinkedHashSet<BundleCapability>();
        Iterator itCapabilities = this.capabilities.iterator();
        while (itCapabilities.hasNext()) {
            BundleCapability capability = (BundleCapability)itCapabilities.next();
            if (!SERVICE_TYPE.equals(capability.getType())) continue;
            set2.add(capability);
        }
        return set2;
    }
}

