/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.trigger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.gradle.internal.impldep.org.apache.ivy.core.IvyPatternHelper;
import org.gradle.internal.impldep.org.apache.ivy.core.event.IvyEvent;
import org.gradle.internal.impldep.org.apache.ivy.core.resolve.ResolveProcessException;
import org.gradle.internal.impldep.org.apache.ivy.plugins.trigger.AbstractTrigger;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class LogTrigger
extends AbstractTrigger {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String message = "";
    private File file = null;
    private boolean append = true;
    private String encoding = "";

    public void progress(IvyEvent event) {
        this.log(IvyPatternHelper.substituteVariables(this.message, event.getAttributes()));
    }

    protected void log(String message2) {
        if (this.file == null) {
            Message.info(message2);
        } else {
            Writer out = null;
            try {
                message2 = message2 + LINE_SEPARATOR;
                String filename = this.file.getAbsolutePath();
                out = this.encoding == null || this.encoding.length() == 0 ? new FileWriter(filename, this.append) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, this.append), this.encoding));
                out.write(message2, 0, message2.length());
            }
            catch (IOException e) {
                throw new ResolveProcessException(e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new ResolveProcessException(e);
                    }
                }
            }
        }
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

