/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.gradle.internal.impldep.org.apache.xml.serialize.BaseMarkupSerializer;
import org.gradle.internal.impldep.org.apache.xml.serialize.ElementState;
import org.gradle.internal.impldep.org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;
    protected boolean fNamespacePrefixes = true;
    private boolean fPreserveSpace;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(outputStream);
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
        if (this.fNSBinder == null) {
            this.fNSBinder = new NamespaceSupport();
            this.fLocalNSBinder = new NamespaceSupport();
            this.fSymbolTable = new SymbolTable();
        }
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        try {
            String string5;
            Object object;
            String string6;
            Object object2;
            if (this._printer == null) {
                String string7 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(string7);
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string3 == null || string3.length() == 0 ? string4 : string3);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            attributes = this.extractNamespaces(attributes);
            if (string4 == null || string4.length() == 0) {
                if (string3 == null) {
                    String string8 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoName", null);
                    throw new SAXException(string8);
                }
                string4 = string2 != null && !string2.equals("") ? ((object2 = this.getPrefix(string2)) != null && ((String)object2).length() > 0 ? (String)object2 + ":" + string3 : string3) : string3;
            }
            this._printer.printText('<');
            this._printer.printText(string4);
            this._printer.indent();
            if (attributes != null) {
                int n = 0;
                while (n < attributes.getLength()) {
                    this._printer.printSpace();
                    string6 = attributes.getQName(n);
                    if (string6 != null && string6.length() == 0) {
                        string6 = attributes.getLocalName(n);
                        object = attributes.getURI(n);
                        if (!(object == null || ((String)object).length() == 0 || string2 != null && string2.length() != 0 && ((String)object).equals(string2) || (object2 = this.getPrefix((String)object)) == null || ((String)object2).length() <= 0)) {
                            string6 = (String)object2 + ":" + string6;
                        }
                    }
                    if ((string5 = attributes.getValue(n)) == null) {
                        string5 = "";
                    }
                    this._printer.printText(string6);
                    this._printer.printText("=\"");
                    this.printEscaped(string5);
                    this._printer.printText('\"');
                    if (string6.equals("xml:space")) {
                        bl = string5.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            if (this._prefixes != null) {
                object2 = this._prefixes.entrySet().iterator();
                while (object2.hasNext()) {
                    this._printer.printSpace();
                    object = (Map.Entry)object2.next();
                    string5 = (String)object.getKey();
                    string6 = (String)object.getValue();
                    if (string6.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(string5);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(string6);
                    this._printer.printText("=\"");
                    this.printEscaped(string5);
                    this._printer.printText('\"');
                }
            }
            elementState = this.enterElementState(string2, string3, string4, bl);
            string6 = string3 == null || string3.length() == 0 ? string4 : string2 + "^" + string3;
            elementState.doCData = this._format.isCDataElement(string6);
            elementState.unescaped = this._format.isNonEscapingElement(string6);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        try {
            this.endElementIO(string2, string3, string4);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElementIO(String string2, String string3, String string4) throws IOException {
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this._printer.printText("/>");
        } else {
            if (elementState.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(elementState.rawName);
            this._printer.printText('>');
        }
        elementState = this.leaveElementState();
        elementState.afterElement = true;
        elementState.afterComment = false;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String string2, AttributeList attributeList) throws SAXException {
        try {
            if (this._printer == null) {
                String string3 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(string3);
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string2);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(string2);
            this._printer.indent();
            if (attributeList != null) {
                int n = 0;
                while (n < attributeList.getLength()) {
                    this._printer.printSpace();
                    String string4 = attributeList.getName(n);
                    String string5 = attributeList.getValue(n);
                    if (string5 != null) {
                        this._printer.printText(string4);
                        this._printer.printText("=\"");
                        this.printEscaped(string5);
                        this._printer.printText('\"');
                    }
                    if (string4.equals("xml:space")) {
                        bl = string5.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            elementState = this.enterElementState(null, null, string2, bl);
            elementState.doCData = this._format.isCDataElement(string2);
            elementState.unescaped = this._format.isNonEscapingElement(string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string2) throws SAXException {
        this.endElement(null, null, string2);
    }

    protected void startDocument(String string2) throws IOException {
        String string3 = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                String string4 = this._format.getEncoding();
                if (string4 != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(string4);
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this._printer.printText(stringBuffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string2);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            int n = 0;
                            while (n < 18 + string2.length()) {
                                this._printer.printText(" ");
                                ++n;
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (string3 != null && string3.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(string3, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (string3 != null && string3.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string2);
                    this._printer.printText(" [");
                    this.printText(string3, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element element) throws IOException {
        String string2;
        String string3;
        Attr attr;
        int n;
        if (this.fNamespaces) {
            this.fLocalNSBinder.reset();
            this.fNSBinder.pushContext();
        }
        String string4 = element.getTagName();
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string4);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (elementState.inCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
        }
        this.fPreserveSpace = elementState.preserveSpace;
        int n2 = 0;
        NamedNodeMap namedNodeMap = null;
        if (element.hasAttributes()) {
            namedNodeMap = element.getAttributes();
            n2 = namedNodeMap.getLength();
        }
        if (!this.fNamespaces) {
            this._printer.printText('<');
            this._printer.printText(string4);
            this._printer.indent();
            n = 0;
            while (n < n2) {
                attr = (Attr)namedNodeMap.item(n);
                string3 = attr.getName();
                string2 = attr.getValue();
                if (string2 == null) {
                    string2 = "";
                }
                this.printAttribute(string3, string2, attr.getSpecified(), attr);
                ++n;
            }
        } else {
            String string5;
            boolean bl;
            String string6;
            String string7;
            n = 0;
            while (n < n2) {
                attr = (Attr)namedNodeMap.item(n);
                string7 = attr.getNamespaceURI();
                if (string7 != null && string7.equals(NamespaceContext.XMLNS_URI)) {
                    string2 = attr.getNodeValue();
                    if (string2 == null) {
                        string2 = XMLSymbols.EMPTY_STRING;
                    }
                    if (string2.equals(NamespaceContext.XMLNS_URI)) {
                        if (this.fDOMErrorHandler != null) {
                            string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CantBindXMLNS", null);
                            this.modifyDOMError(string6, (short)2, null, attr);
                            bl = this.fDOMErrorHandler.handleError(this.fDOMError);
                            if (!bl) {
                                throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SerializationStopped", null));
                            }
                        }
                    } else {
                        string5 = attr.getPrefix();
                        string5 = string5 == null || string5.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                        string6 = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (string5 == XMLSymbols.PREFIX_XMLNS) {
                            if ((string2 = this.fSymbolTable.addSymbol(string2)).length() != 0) {
                                this.fNSBinder.declarePrefix(string6, string2);
                            }
                        } else {
                            string2 = this.fSymbolTable.addSymbol(string2);
                            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, string2);
                        }
                    }
                }
                ++n;
            }
            string7 = element.getNamespaceURI();
            string5 = element.getPrefix();
            if (string7 != null && string5 != null && string7.length() == 0 && string5.length() != 0) {
                string5 = null;
                this._printer.printText('<');
                this._printer.printText(element.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(string4);
                this._printer.indent();
            }
            if (string7 != null) {
                string7 = this.fSymbolTable.addSymbol(string7);
                String string8 = string5 = string5 == null || string5.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                if (this.fNSBinder.getURI(string5) != string7) {
                    if (this.fNamespacePrefixes) {
                        this.printNamespaceAttr(string5, string7);
                    }
                    this.fLocalNSBinder.declarePrefix(string5, string7);
                    this.fNSBinder.declarePrefix(string5, string7);
                }
            } else if (element.getLocalName() == null) {
                if (this.fDOMErrorHandler != null) {
                    string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{element.getNodeName()});
                    this.modifyDOMError(string6, (short)2, null, element);
                    bl = this.fDOMErrorHandler.handleError(this.fDOMError);
                    if (!bl) {
                        throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SerializationStopped", null));
                    }
                }
            } else {
                string7 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                if (string7 != null && string7.length() > 0) {
                    if (this.fNamespacePrefixes) {
                        this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    }
                    this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                }
            }
            n = 0;
            while (n < n2) {
                attr = (Attr)namedNodeMap.item(n);
                string2 = attr.getValue();
                string3 = attr.getNodeName();
                string7 = attr.getNamespaceURI();
                if (string7 != null && string7.length() == 0) {
                    string7 = null;
                    string3 = attr.getLocalName();
                }
                if (string2 == null) {
                    string2 = XMLSymbols.EMPTY_STRING;
                }
                if (string7 != null) {
                    string5 = attr.getPrefix();
                    string5 = string5 == null ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                    string6 = this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (string7 != null && string7.equals(NamespaceContext.XMLNS_URI)) {
                        String string9;
                        string5 = attr.getPrefix();
                        string5 = string5 == null || string5.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                        string6 = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (string5 == XMLSymbols.PREFIX_XMLNS) {
                            string9 = this.fLocalNSBinder.getURI(string6);
                            if ((string2 = this.fSymbolTable.addSymbol(string2)).length() != 0 && string9 == null) {
                                if (this.fNamespacePrefixes) {
                                    this.printNamespaceAttr(string6, string2);
                                }
                                this.fLocalNSBinder.declarePrefix(string6, string2);
                            }
                        } else {
                            string7 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                            string9 = this.fLocalNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                            string2 = this.fSymbolTable.addSymbol(string2);
                            if (string9 == null && this.fNamespacePrefixes) {
                                this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, string2);
                            }
                        }
                    } else {
                        string7 = this.fSymbolTable.addSymbol(string7);
                        String string10 = this.fNSBinder.getURI(string5);
                        if (string5 == XMLSymbols.EMPTY_STRING || string10 != string7) {
                            string3 = attr.getNodeName();
                            String string11 = this.fNSBinder.getPrefix(string7);
                            if (string11 != null && string11 != XMLSymbols.EMPTY_STRING) {
                                string5 = string11;
                                string3 = string5 + ":" + string6;
                            } else {
                                if (string5 == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(string5) != null) {
                                    int n3 = 1;
                                    string5 = this.fSymbolTable.addSymbol(PREFIX + n3++);
                                    while (this.fLocalNSBinder.getURI(string5) != null) {
                                        string5 = this.fSymbolTable.addSymbol(PREFIX + n3++);
                                    }
                                    string3 = string5 + ":" + string6;
                                }
                                if (this.fNamespacePrefixes) {
                                    this.printNamespaceAttr(string5, string7);
                                }
                                string2 = this.fSymbolTable.addSymbol(string2);
                                this.fLocalNSBinder.declarePrefix(string5, string2);
                                this.fNSBinder.declarePrefix(string5, string7);
                            }
                        }
                        this.printAttribute(string3, string2 == null ? XMLSymbols.EMPTY_STRING : string2, attr.getSpecified(), attr);
                    }
                } else if (attr.getLocalName() == null) {
                    if (this.fDOMErrorHandler != null) {
                        string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr.getNodeName()});
                        this.modifyDOMError(string6, (short)2, null, attr);
                        boolean bl2 = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!bl2) {
                            throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SerializationStopped", null));
                        }
                    }
                    this.printAttribute(string3, string2, attr.getSpecified(), attr);
                } else {
                    this.printAttribute(string3, string2, attr.getSpecified(), attr);
                }
                ++n;
            }
        }
        if (element.hasChildNodes()) {
            elementState = this.enterElementState(null, null, string4, this.fPreserveSpace);
            elementState.doCData = this._format.isCDataElement(string4);
            elementState.unescaped = this._format.isNonEscapingElement(string4);
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this.endElementIO(null, null, string4);
        } else {
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this._printer.unindent();
            this._printer.printText("/>");
            elementState.afterElement = true;
            elementState.afterComment = false;
            elementState.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String string2, String string3) throws IOException {
        this._printer.printSpace();
        if (string2 == XMLSymbols.EMPTY_STRING) {
            this._printer.printText(XMLSymbols.PREFIX_XMLNS);
        } else {
            this._printer.printText("xmlns:" + string2);
        }
        this._printer.printText("=\"");
        this.printEscaped(string3);
        this._printer.printText('\"');
    }

    private void printAttribute(String string2, String string3, boolean bl, Attr attr) throws IOException {
        if (bl || (this.features & 0x40) == 0) {
            if (this.fDOMFilter != null && (this.fDOMFilter.getWhatToShow() & 2) != 0) {
                short s = this.fDOMFilter.acceptNode(attr);
                switch (s) {
                    case 2: 
                    case 3: {
                        return;
                    }
                }
            }
            this._printer.printSpace();
            this._printer.printText(string2);
            this._printer.printText("=\"");
            this.printEscaped(string3);
            this._printer.printText('\"');
        }
        if (string2.equals("xml:space")) {
            this.fPreserveSpace = string3.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    protected String getEntityRef(int n) {
        switch (n) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attributes) throws SAXException {
        if (attributes == null) {
            return null;
        }
        int n = attributes.getLength();
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n2 = n - 1;
        while (n2 >= 0) {
            String string2 = attributesImpl.getQName(n2);
            if (string2.startsWith("xmlns")) {
                if (string2.length() == 5) {
                    this.startPrefixMapping("", attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                } else if (string2.charAt(5) == ':') {
                    this.startPrefixMapping(string2.substring(6), attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                }
            }
            --n2;
        }
        return attributesImpl;
    }

    protected void printEscaped(String string2) throws IOException {
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (!XMLChar.isValid(c)) {
                if (++n2 < n) {
                    this.surrogates(c, string2.charAt(n2), false);
                } else {
                    this.fatalError("The character '" + (char)c + "' is an invalid XML character");
                }
            } else if (c == '\n' || c == '\r' || c == '\t') {
                this.printHex(c);
            } else if (c == '<') {
                this._printer.printText("&lt;");
            } else if (c == '&') {
                this._printer.printText("&amp;");
            } else if (c == '\"') {
                this._printer.printText("&quot;");
            } else if (c >= ' ' && this._encodingInfo.isPrintable(c)) {
                this._printer.printText(c);
            } else {
                this.printHex(c);
            }
            ++n2;
        }
    }

    protected void printXMLChar(int n) throws IOException {
        if (n == 13) {
            this.printHex(n);
        } else if (n == 60) {
            this._printer.printText("&lt;");
        } else if (n == 38) {
            this._printer.printText("&amp;");
        } else if (n == 62) {
            this._printer.printText("&gt;");
        } else if (n == 10 || n == 9 || n >= 32 && this._encodingInfo.isPrintable((char)n)) {
            this._printer.printText((char)n);
        } else {
            this.printHex(n);
        }
    }

    protected void printText(String string2, boolean bl, boolean bl2) throws IOException {
        int n = string2.length();
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                char c = string2.charAt(n2);
                if (!XMLChar.isValid(c)) {
                    if (++n2 < n) {
                        this.surrogates(c, string2.charAt(n2), true);
                    } else {
                        this.fatalError("The character '" + c + "' is an invalid XML character");
                    }
                } else if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printXMLChar(c);
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                char c = string2.charAt(n3);
                if (!XMLChar.isValid(c)) {
                    if (++n3 < n) {
                        this.surrogates(c, string2.charAt(n3), true);
                    } else {
                        this.fatalError("The character '" + c + "' is an invalid XML character");
                    }
                } else if (bl2) {
                    this._printer.printText(c);
                } else {
                    this.printXMLChar(c);
                }
                ++n3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void printText(char[] var1_1, int var2_2, int var3_3, boolean var4_4, boolean var5_5) throws IOException {
        block8: {
            if (!var4_4) ** GOTO lbl25
            while (var3_3-- > 0) {
                if (!XMLChar.isValid(var6_6 = var1_1[var2_2++])) {
                    if (var3_3-- > 0) {
                        this.surrogates(var6_6, var1_1[var2_2++], true);
                        continue;
                    }
                    this.fatalError("The character '" + var6_6 + "' is an invalid XML character");
                    continue;
                }
                if (var5_5) {
                    this._printer.printText(var6_6);
                    continue;
                }
                this.printXMLChar(var6_6);
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                if (!XMLChar.isValid(var6_7 = var1_1[var2_2++])) {
                    if (var3_3-- > 0) {
                        this.surrogates(var6_7, var1_1[var2_2++], true);
                        continue;
                    }
                    this.fatalError("The character '" + var6_7 + "' is an invalid XML character");
                    continue;
                }
                if (var5_5) {
                    this._printer.printText(var6_7);
                    continue;
                }
                this.printXMLChar(var6_7);
lbl25:
                // 5 sources

                ** while (var3_3-- > 0)
            }
        }
    }

    protected void checkUnboundNamespacePrefixedNode(Node node) throws IOException {
        if (this.fNamespaces) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                Node node3 = node2.getNextSibling();
                String string2 = node2.getPrefix();
                String string3 = string2 = string2 == null || string2.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string2);
                if (this.fNSBinder.getURI(string2) == null && string2 != null) {
                    this.fatalError("The replacement text of the entity node '" + node.getNodeName() + "' contains an element node '" + node2.getNodeName() + "' with an undeclared prefix '" + string2 + "'.");
                }
                if (node2.getNodeType() == 1) {
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        String string4 = namedNodeMap.item(n).getPrefix();
                        String string5 = string4 = string4 == null || string4.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string4);
                        if (this.fNSBinder.getURI(string4) == null && string4 != null) {
                            this.fatalError("The replacement text of the entity node '" + node.getNodeName() + "' contains an element node '" + node2.getNodeName() + "' with an attribute '" + namedNodeMap.item(n).getNodeName() + "' an undeclared prefix '" + string4 + "'.");
                        }
                        ++n;
                    }
                }
                if (node2.hasChildNodes()) {
                    this.checkUnboundNamespacePrefixedNode(node2);
                }
                node2 = node3;
            }
        }
    }

    public boolean reset() {
        super.reset();
        if (this.fNSBinder != null) {
            this.fNSBinder.reset();
            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        }
        return true;
    }
}

