/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.gradle.internal.impldep.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.gradle.internal.impldep.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.gradle.internal.impldep.org.bouncycastle.crypto.KeyGenerationParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECDomainParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.gradle.internal.impldep.org.bouncycastle.math.ec.ECConstants;
import org.gradle.internal.impldep.org.bouncycastle.math.ec.ECMultiplier;
import org.gradle.internal.impldep.org.bouncycastle.math.ec.ECPoint;
import org.gradle.internal.impldep.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.gradle.internal.impldep.org.bouncycastle.math.ec.WNafUtil;
import org.gradle.internal.impldep.org.bouncycastle.util.BigIntegers;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = BigIntegers.createRandomBigInteger(n, this.random)).compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

