/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.jce.spec;

import java.security.spec.AlgorithmParameterSpec;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.gradle.internal.impldep.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.gradle.internal.impldep.org.bouncycastle.asn1.cryptopro.GOST3410NamedParameters;
import org.gradle.internal.impldep.org.bouncycastle.asn1.cryptopro.GOST3410ParamSetParameters;
import org.gradle.internal.impldep.org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.gradle.internal.impldep.org.bouncycastle.jce.interfaces.GOST3410Params;
import org.gradle.internal.impldep.org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;

public class GOST3410ParameterSpec
implements AlgorithmParameterSpec,
GOST3410Params {
    private GOST3410PublicKeyParameterSetSpec keyParameters;
    private String keyParamSetOID;
    private String digestParamSetOID;
    private String encryptionParamSetOID;

    public GOST3410ParameterSpec(String string2, String string3, String string4) {
        GOST3410ParamSetParameters gOST3410ParamSetParameters;
        block3: {
            gOST3410ParamSetParameters = null;
            try {
                gOST3410ParamSetParameters = GOST3410NamedParameters.getByOID(new ASN1ObjectIdentifier(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = GOST3410NamedParameters.getOID(string2);
                if (aSN1ObjectIdentifier == null) break block3;
                string2 = aSN1ObjectIdentifier.getId();
                gOST3410ParamSetParameters = GOST3410NamedParameters.getByOID(aSN1ObjectIdentifier);
            }
        }
        if (gOST3410ParamSetParameters == null) {
            throw new IllegalArgumentException("no key parameter set for passed in name/OID.");
        }
        this.keyParameters = new GOST3410PublicKeyParameterSetSpec(gOST3410ParamSetParameters.getP(), gOST3410ParamSetParameters.getQ(), gOST3410ParamSetParameters.getA());
        this.keyParamSetOID = string2;
        this.digestParamSetOID = string3;
        this.encryptionParamSetOID = string4;
    }

    public GOST3410ParameterSpec(String string2, String string3) {
        this(string2, string3, null);
    }

    public GOST3410ParameterSpec(String string2) {
        this(string2, CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet.getId(), null);
    }

    public GOST3410ParameterSpec(GOST3410PublicKeyParameterSetSpec gOST3410PublicKeyParameterSetSpec) {
        this.keyParameters = gOST3410PublicKeyParameterSetSpec;
        this.digestParamSetOID = CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet.getId();
        this.encryptionParamSetOID = null;
    }

    public String getPublicKeyParamSetOID() {
        return this.keyParamSetOID;
    }

    public GOST3410PublicKeyParameterSetSpec getPublicKeyParameters() {
        return this.keyParameters;
    }

    public String getDigestParamSetOID() {
        return this.digestParamSetOID;
    }

    public String getEncryptionParamSetOID() {
        return this.encryptionParamSetOID;
    }

    public boolean equals(Object object) {
        if (object instanceof GOST3410ParameterSpec) {
            GOST3410ParameterSpec gOST3410ParameterSpec = (GOST3410ParameterSpec)object;
            return this.keyParameters.equals(gOST3410ParameterSpec.keyParameters) && this.digestParamSetOID.equals(gOST3410ParameterSpec.digestParamSetOID) && (this.encryptionParamSetOID == gOST3410ParameterSpec.encryptionParamSetOID || this.encryptionParamSetOID != null && this.encryptionParamSetOID.equals(gOST3410ParameterSpec.encryptionParamSetOID));
        }
        return false;
    }

    public int hashCode() {
        return this.keyParameters.hashCode() ^ this.digestParamSetOID.hashCode() ^ (this.encryptionParamSetOID != null ? this.encryptionParamSetOID.hashCode() : 0);
    }

    public static GOST3410ParameterSpec fromPublicKeyAlg(GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters) {
        if (gOST3410PublicKeyAlgParameters.getEncryptionParamSet() != null) {
            return new GOST3410ParameterSpec(gOST3410PublicKeyAlgParameters.getPublicKeyParamSet().getId(), gOST3410PublicKeyAlgParameters.getDigestParamSet().getId(), gOST3410PublicKeyAlgParameters.getEncryptionParamSet().getId());
        }
        return new GOST3410ParameterSpec(gOST3410PublicKeyAlgParameters.getPublicKeyParamSet().getId(), gOST3410PublicKeyAlgParameters.getDigestParamSet().getId());
    }
}

