/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce;

import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.io.CipherInputStream;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.JcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

class OperatorHelper {
    private JcaJceHelper helper;

    OperatorHelper(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    String getDigestName(int n) throws PGPException {
        switch (n) {
            case 2: {
                return "SHA-1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA-256";
            }
            case 9: {
                return "SHA-384";
            }
            case 10: {
                return "SHA-512";
            }
            case 11: {
                return "SHA-224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + n);
    }

    MessageDigest createDigest(int n) throws GeneralSecurityException, PGPException {
        MessageDigest messageDigest;
        String string2 = this.getDigestName(n);
        try {
            messageDigest = this.helper.createMessageDigest(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (n >= 8 && n <= 11) {
                messageDigest = this.helper.createMessageDigest("SHA" + string2.substring(4));
            }
            throw noSuchAlgorithmException;
        }
        return messageDigest;
    }

    KeyFactory createKeyFactory(String string2) throws GeneralSecurityException, PGPException {
        return this.helper.createKeyFactory(string2);
    }

    public KeyAgreement createKeyAgreement(String string2) throws GeneralSecurityException {
        return this.helper.createKeyAgreement(string2);
    }

    public KeyPairGenerator createKeyPairGenerator(String string2) throws GeneralSecurityException {
        return this.helper.createKeyPairGenerator(string2);
    }

    PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, PGPUtil.getSymmetricCipherName(n));
            final Cipher cipher = this.createStreamCipher(n, bl);
            if (bl) {
                byte[] byArray2 = new byte[cipher.getBlockSize()];
                cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray2));
            } else {
                cipher.init(2, secretKeySpec);
            }
            return new PGPDataDecryptor(){

                public InputStream getInputStream(InputStream inputStream) {
                    return new CipherInputStream(inputStream, cipher);
                }

                public int getBlockSize() {
                    return cipher.getBlockSize();
                }

                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    Cipher createStreamCipher(int n, boolean bl) throws PGPException {
        String string2 = bl ? "CFB" : "OpenPGPCFB";
        String string3 = PGPUtil.getSymmetricCipherName(n) + "/" + string2 + "/NoPadding";
        return this.createCipher(string3);
    }

    Cipher createCipher(String string2) throws PGPException {
        try {
            return this.helper.createCipher(string2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    Cipher createPublicKeyCipher(int n) throws PGPException {
        switch (n) {
            case 1: 
            case 2: {
                return this.createCipher("RSA/ECB/PKCS1Padding");
            }
            case 16: 
            case 20: {
                return this.createCipher("ElGamal/ECB/PKCS1Padding");
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
            case 22: {
                throw new PGPException("Can't use EDDSA for encryption.");
            }
        }
        throw new PGPException("unknown asymmetric algorithm: " + n);
    }

    Cipher createKeyWrapper(int n) throws PGPException {
        try {
            switch (n) {
                case 7: 
                case 8: 
                case 9: {
                    return this.helper.createCipher("AESWrap");
                }
                case 11: 
                case 12: 
                case 13: {
                    return this.helper.createCipher("CamelliaWrap");
                }
            }
            throw new PGPException("unknown wrap algorithm: " + n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private Signature createSignature(String string2) throws PGPException {
        try {
            return this.helper.createSignature(string2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("cannot create signature: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public Signature createSignature(int n, int n2) throws PGPException {
        String string2;
        switch (n) {
            case 1: 
            case 3: {
                string2 = "RSA";
                break;
            }
            case 17: {
                string2 = "DSA";
                break;
            }
            case 16: 
            case 20: {
                string2 = "ElGamal";
                break;
            }
            case 19: {
                string2 = "ECDSA";
                break;
            }
            case 22: {
                return this.createSignature("Ed25519");
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + n);
            }
        }
        return this.createSignature(PGPUtil.getDigestName(n2) + "with" + string2);
    }

    public AlgorithmParameters createAlgorithmParameters(String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.helper.createAlgorithmParameters(string2);
    }
}

