/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.gradle.internal.impldep.org.eclipse.jgit.api.GitCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.InvalidTagNameException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.NoHeadException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectInserter;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.PersonIdent;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Ref;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RefUpdate;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RepositoryState;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.TagBuilder;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevObject;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;

public class TagCommand
extends GitCommand<Ref> {
    private RevObject id;
    private String name;
    private String message;
    private PersonIdent tagger;
    private boolean signed;
    private boolean forceUpdate;
    private boolean annotated = true;

    protected TagCommand(Repository repo) {
        super(repo);
    }

    /*
     * Loose catch block
     */
    @Override
    public Ref call() throws GitAPIException, ConcurrentRefUpdateException, InvalidTagNameException, NoHeadException {
        this.checkCallable();
        RepositoryState state2 = this.repo.getRepositoryState();
        this.processOptions(state2);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RevWalk revWalk = new RevWalk(this.repo);){
                Ref ref;
                ObjectInserter inserter;
                Throwable throwable2;
                block26: {
                    if (this.id == null) {
                        ObjectId objectId = this.repo.resolve("HEAD^{commit}");
                        if (objectId == null) {
                            throw new NoHeadException(JGitText.get().tagOnRepoWithoutHEADCurrentlyNotSupported);
                        }
                        this.id = revWalk.parseCommit(objectId);
                    }
                    if (!this.annotated) {
                        if (this.message != null || this.tagger != null) {
                            throw new JGitInternalException(JGitText.get().messageAndTaggerNotAllowedInUnannotatedTags);
                        }
                        return this.updateTagRef(this.id, revWalk, this.name, "SimpleTag[" + this.name + " : " + this.id + "]");
                    }
                    TagBuilder newTag = new TagBuilder();
                    newTag.setTag(this.name);
                    newTag.setMessage(this.message);
                    newTag.setTagger(this.tagger);
                    newTag.setObjectId(this.id);
                    throwable2 = null;
                    Object var7_11 = null;
                    inserter = this.repo.newObjectInserter();
                    ObjectId tagId = inserter.insert(newTag);
                    inserter.flush();
                    String tag = newTag.getTag();
                    ref = this.updateTagRef(tagId, revWalk, tag, newTag.toString());
                    if (inserter == null) break block26;
                    inserter.close();
                }
                return ref;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (inserter != null) {
                                inserter.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfTagCommand, e);
        }
    }

    private Ref updateTagRef(ObjectId tagId, RevWalk revWalk, String tagName, String newTagToString) throws IOException, ConcurrentRefUpdateException, RefAlreadyExistsException {
        String refName = "refs/tags/" + tagName;
        RefUpdate tagRef = this.repo.updateRef(refName);
        tagRef.setNewObjectId(tagId);
        tagRef.setForceUpdate(this.forceUpdate);
        tagRef.setRefLogMessage("tagged " + this.name, false);
        RefUpdate.Result updateResult = tagRef.update(revWalk);
        switch (updateResult) {
            case NEW: 
            case FORCED: {
                return this.repo.exactRef(refName);
            }
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, tagRef.getRef(), updateResult);
            }
            case REJECTED: {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().tagAlreadyExists, newTagToString));
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{refName, newTagToString, updateResult}));
    }

    private void processOptions(RepositoryState state2) throws InvalidTagNameException {
        if (this.tagger == null && this.annotated) {
            this.tagger = new PersonIdent(this.repo);
        }
        if (this.name == null || !Repository.isValidRefName("refs/tags/" + this.name)) {
            throw new InvalidTagNameException(MessageFormat.format(JGitText.get().tagNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (this.signed) {
            throw new UnsupportedOperationException(JGitText.get().signingNotSupportedOnTag);
        }
    }

    public TagCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public TagCommand setMessage(String message2) {
        this.checkCallable();
        this.message = message2;
        return this;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public TagCommand setSigned(boolean signed) {
        this.signed = signed;
        return this;
    }

    public TagCommand setTagger(PersonIdent tagger) {
        this.tagger = tagger;
        return this;
    }

    public PersonIdent getTagger() {
        return this.tagger;
    }

    public RevObject getObjectId() {
        return this.id;
    }

    public TagCommand setObjectId(RevObject id) {
        this.id = id;
        return this;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public TagCommand setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }

    public TagCommand setAnnotated(boolean annotated) {
        this.annotated = annotated;
        return this;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }
}

