/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.storage.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.ConfigInvalidException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.LockFailedException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.LockFile;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Config;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Constants;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.StoredConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.util.FS;
import org.gradle.internal.impldep.org.eclipse.jgit.util.FileUtils;
import org.gradle.internal.impldep.org.eclipse.jgit.util.IO;
import org.gradle.internal.impldep.org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedConfig
extends StoredConfig {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedConfig.class);
    private final File configFile;
    private final FS fs;
    private boolean utf8Bom;
    private volatile FileSnapshot snapshot;
    private volatile ObjectId hash;

    public FileBasedConfig(File cfgLocation, FS fs) {
        this(null, cfgLocation, fs);
    }

    public FileBasedConfig(Config base, File cfgLocation, FS fs) {
        super(base);
        this.configFile = cfgLocation;
        this.fs = fs;
        this.snapshot = FileSnapshot.DIRTY;
        this.hash = ObjectId.zeroId();
    }

    @Override
    protected boolean notifyUponTransientChanges() {
        return false;
    }

    public final File getFile() {
        return this.configFile;
    }

    /*
     * Loose catch block
     */
    @Override
    public void load() throws IOException, ConfigInvalidException {
        int maxRetries = 5;
        int retryDelayMillis = 20;
        int retries = 0;
        while (true) {
            FileSnapshot oldSnapshot = this.snapshot;
            FileSnapshot newSnapshot = FileSnapshot.saveNoConfig(this.getFile());
            try {
                byte[] in = IO.readFully(this.getFile());
                ObjectId newHash = FileBasedConfig.hash(in);
                if (this.hash.equals(newHash)) {
                    if (oldSnapshot.equals(newSnapshot)) {
                        oldSnapshot.setClean(newSnapshot);
                    } else {
                        this.snapshot = newSnapshot;
                    }
                } else {
                    String decoded;
                    if (this.isUtf8(in)) {
                        decoded = RawParseUtils.decode(StandardCharsets.UTF_8, in, 3, in.length);
                        this.utf8Bom = true;
                    } else {
                        decoded = RawParseUtils.decode(in);
                    }
                    this.fromText(decoded);
                    this.snapshot = newSnapshot;
                    this.hash = newHash;
                }
                return;
            }
            catch (FileNotFoundException noFile) {
                if (retries < 5 && this.configFile.exists()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(MessageFormat.format(JGitText.get().configHandleMayBeLocked, retries), noFile);
                    }
                    try {
                        Thread.sleep(retryDelayMillis);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    ++retries;
                    retryDelayMillis *= 2;
                    continue;
                }
                if (this.configFile.exists()) {
                    throw noFile;
                }
                this.clear();
                this.snapshot = newSnapshot;
                return;
            }
            catch (IOException e) {
                if (FileUtils.isStaleFileHandle(e) && retries < 5) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(MessageFormat.format(JGitText.get().configHandleIsStale, retries), e);
                    }
                    ++retries;
                    continue;
                }
                throw new IOException(MessageFormat.format(JGitText.get().cannotReadFile, this.getFile()), e);
            }
            break;
        }
        catch (ConfigInvalidException e) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, this.getFile()), e);
        }
    }

    @Override
    public void save() throws IOException {
        byte[] out;
        String text = this.toText();
        if (this.utf8Bom) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(239);
            bos.write(187);
            bos.write(191);
            bos.write(text.getBytes(StandardCharsets.UTF_8));
            out = bos.toByteArray();
        } else {
            out = Constants.encode(text);
        }
        LockFile lf = new LockFile(this.getFile());
        if (!lf.lock()) {
            throw new LockFailedException(this.getFile());
        }
        try {
            lf.setNeedSnapshot(true);
            lf.write(out);
            if (!lf.commit()) {
                throw new IOException(MessageFormat.format(JGitText.get().cannotCommitWriteTo, this.getFile()));
            }
        }
        finally {
            lf.unlock();
        }
        this.snapshot = lf.getCommitSnapshot();
        this.hash = FileBasedConfig.hash(out);
        this.fireConfigChangedEvent();
    }

    @Override
    public void clear() {
        this.hash = FileBasedConfig.hash(new byte[0]);
        super.clear();
    }

    private static ObjectId hash(byte[] rawText) {
        return ObjectId.fromRaw(Constants.newMessageDigest().digest(rawText));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getFile().getPath() + "]";
    }

    public boolean isOutdated() {
        return this.snapshot.isModified(this.getFile());
    }

    @Override
    protected byte[] readIncludedConfig(String relPath) throws ConfigInvalidException {
        File file = relPath.startsWith("~/") ? this.fs.resolve(this.fs.userHome(), relPath.substring(2)) : this.fs.resolve(this.configFile.getParentFile(), relPath);
        if (!file.exists()) {
            return null;
        }
        try {
            return IO.readFully(file);
        }
        catch (IOException ioe) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, relPath), ioe);
        }
    }
}

