/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng;

import org.gradle.internal.impldep.org.testng.internal.junit.ArrayAsserts;

public class AssertJUnit
extends ArrayAsserts {
    protected AssertJUnit() {
    }

    public static void assertTrue(String message2, boolean condition) {
        if (!condition) {
            AssertJUnit.fail(message2);
        }
    }

    public static void assertTrue(boolean condition) {
        AssertJUnit.assertTrue(null, condition);
    }

    public static void assertFalse(String message2, boolean condition) {
        AssertJUnit.assertTrue(message2, !condition);
    }

    public static void assertFalse(boolean condition) {
        AssertJUnit.assertFalse(null, condition);
    }

    public static void fail(String message2) {
        if (null == message2) {
            message2 = "";
        }
        throw new AssertionError((Object)message2);
    }

    public static void fail() {
        AssertJUnit.fail(null);
    }

    public static void assertEquals(String message2, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        AssertJUnit.failNotEquals(message2, expected, actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, String expected, String actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        throw new AssertionError((Object)AssertJUnit.format(message2, expected, actual));
    }

    public static void assertEquals(String expected, String actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, double expected, double actual, double delta) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                AssertJUnit.failNotEquals(message2, new Double(expected), new Double(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            AssertJUnit.failNotEquals(message2, new Double(expected), new Double(actual));
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        AssertJUnit.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message2, float expected, float actual, float delta) {
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                AssertJUnit.failNotEquals(message2, new Float(expected), new Float(actual));
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            AssertJUnit.failNotEquals(message2, new Float(expected), new Float(actual));
        }
    }

    public static void assertEquals(float expected, float actual, float delta) {
        AssertJUnit.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message2, long expected, long actual) {
        AssertJUnit.assertEquals(message2, (Object)expected, (Object)actual);
    }

    public static void assertEquals(long expected, long actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, boolean expected, boolean actual) {
        AssertJUnit.assertEquals(message2, (Object)expected, (Object)actual);
    }

    public static void assertEquals(boolean expected, boolean actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, byte expected, byte actual) {
        AssertJUnit.assertEquals(message2, (Object)expected, (Object)actual);
    }

    public static void assertEquals(byte expected, byte actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, char expected, char actual) {
        AssertJUnit.assertEquals(message2, Character.valueOf(expected), Character.valueOf(actual));
    }

    public static void assertEquals(char expected, char actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, short expected, short actual) {
        AssertJUnit.assertEquals(message2, (Object)expected, (Object)actual);
    }

    public static void assertEquals(short expected, short actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, int expected, int actual) {
        AssertJUnit.assertEquals(message2, (Object)expected, (Object)actual);
    }

    public static void assertEquals(int expected, int actual) {
        AssertJUnit.assertEquals(null, expected, actual);
    }

    public static void assertNotNull(Object object) {
        AssertJUnit.assertNotNull(null, object);
    }

    public static void assertNotNull(String message2, Object object) {
        AssertJUnit.assertTrue(message2, object != null);
    }

    public static void assertNull(Object object) {
        AssertJUnit.assertNull(null, object);
    }

    public static void assertNull(String message2, Object object) {
        AssertJUnit.assertTrue(message2, object == null);
    }

    public static void assertSame(String message2, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        AssertJUnit.failNotSame(message2, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        AssertJUnit.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message2, Object expected, Object actual) {
        if (expected == actual) {
            AssertJUnit.failSame(message2);
        }
    }

    public static void assertNotSame(Object expected, Object actual) {
        AssertJUnit.assertNotSame(null, expected, actual);
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        AssertJUnit.assertEquals("", expected, actual);
    }

    public static void assertEquals(String message2, byte[] expected, byte[] actual) {
        if (expected == actual) {
            return;
        }
        if (null == expected) {
            AssertJUnit.fail("expected a null array, but not null found. " + message2);
        }
        if (null == actual) {
            AssertJUnit.fail("expected not null array, but null found. " + message2);
        }
        AssertJUnit.assertEquals("arrays don't have the same size. " + message2, expected.length, actual.length);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            AssertJUnit.fail("arrays differ firstly at element [" + i + "]; " + AssertJUnit.format(message2, expected[i], actual[i]));
        }
    }

    private static void failSame(String message2) {
        String formatted = "";
        if (message2 != null) {
            formatted = message2 + " ";
        }
        AssertJUnit.fail(formatted + "expected not same");
    }

    private static void failNotSame(String message2, Object expected, Object actual) {
        String formatted = "";
        if (message2 != null) {
            formatted = message2 + " ";
        }
        AssertJUnit.fail(formatted + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    private static void failNotEquals(String message2, Object expected, Object actual) {
        AssertJUnit.fail(AssertJUnit.format(message2, expected, actual));
    }

    static String format(String message2, Object expected, Object actual) {
        String formatted = "";
        if (message2 != null) {
            formatted = message2 + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

