/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng.reporters;

import java.util.Iterator;
import java.util.List;
import org.gradle.internal.impldep.org.testng.ITestContext;
import org.gradle.internal.impldep.org.testng.ITestNGMethod;
import org.gradle.internal.impldep.org.testng.ITestResult;
import org.gradle.internal.impldep.org.testng.TestListenerAdapter;
import org.gradle.internal.impldep.org.testng.internal.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextReporter
extends TestListenerAdapter {
    private int m_verbose = 0;
    private String m_testName = null;

    public TextReporter(String testName, int verbose) {
        this.m_testName = testName;
        this.m_verbose = verbose;
    }

    @Override
    public void onFinish(ITestContext context) {
        if (this.m_verbose >= 2) {
            this.logResults();
        }
    }

    private ITestNGMethod[] resultsToMethods(List<ITestResult> results) {
        ITestNGMethod[] result = new ITestNGMethod[results.size()];
        int i = 0;
        for (ITestResult tr : results) {
            result[i++] = tr.getMethod();
        }
        return result;
    }

    private void logResults() {
        String stackTrace;
        Throwable ex;
        ITestResult tr;
        ITestResult o2;
        Iterator<ITestResult> i$ = this.getConfigurationFailures().iterator();
        while (i$.hasNext()) {
            tr = o2 = i$.next();
            ex = tr.getThrowable();
            stackTrace = "";
            if (ex != null && this.m_verbose >= 2) {
                stackTrace = Utils.stackTrace(ex, false)[0];
            }
            this.logResult("FAILED CONFIGURATION", Utils.detailedMethodName(tr.getMethod(), false), tr.getMethod().getDescription(), stackTrace, tr.getParameters(), tr.getMethod().getMethod().getParameterTypes());
        }
        i$ = this.getConfigurationSkips().iterator();
        while (i$.hasNext()) {
            tr = o2 = i$.next();
            this.logResult("SKIPPED CONFIGURATION", Utils.detailedMethodName(tr.getMethod(), false), tr.getMethod().getDescription(), null, tr.getParameters(), tr.getMethod().getMethod().getParameterTypes());
        }
        i$ = this.getPassedTests().iterator();
        while (i$.hasNext()) {
            tr = o2 = i$.next();
            this.logResult("PASSED", tr, null);
        }
        i$ = this.getFailedTests().iterator();
        while (i$.hasNext()) {
            tr = o2 = i$.next();
            ex = tr.getThrowable();
            stackTrace = "";
            if (ex != null && this.m_verbose >= 2) {
                stackTrace = Utils.stackTrace(ex, false)[0];
            }
            this.logResult("FAILED", tr, stackTrace);
        }
        for (ITestResult o2 : this.getSkippedTests()) {
            Throwable throwable = (tr = o2).getThrowable();
            this.logResult("SKIPPED", tr, throwable != null ? Utils.stackTrace(throwable, false)[0] : null);
        }
        ITestNGMethod[] ft = this.resultsToMethods(this.getFailedTests());
        StringBuffer logBuf = new StringBuffer("\n===============================================\n");
        logBuf.append("    ").append(this.m_testName).append("\n");
        logBuf.append("    Tests run: ").append(Utils.calculateInvokedMethodCount(this.getAllTestMethods())).append(", Failures: ").append(Utils.calculateInvokedMethodCount(ft)).append(", Skips: ").append(Utils.calculateInvokedMethodCount(this.resultsToMethods(this.getSkippedTests())));
        int confFailures = this.getConfigurationFailures().size();
        int confSkips = this.getConfigurationSkips().size();
        if (confFailures > 0 || confSkips > 0) {
            logBuf.append("\n").append("    Configuration Failures: ").append(confFailures).append(", Skips: ").append(confSkips);
        }
        logBuf.append("\n===============================================\n");
        this.logResult("", logBuf.toString());
    }

    private String getName() {
        return this.m_testName;
    }

    private void logResult(String status, ITestResult tr, String stackTrace) {
        this.logResult(status, tr.getName(), tr.getMethod().getDescription(), stackTrace, tr.getParameters(), tr.getMethod().getMethod().getParameterTypes());
    }

    private void logResult(String status, String message2) {
        StringBuffer buf = new StringBuffer();
        if (Utils.isStringNotBlank(status)) {
            buf.append(status).append(": ");
        }
        buf.append(message2);
        System.out.println(buf);
    }

    private void logResult(String status, String name, String description, String stackTrace, Object[] params, Class[] paramTypes) {
        int i;
        StringBuffer msg = new StringBuffer(name);
        if (null != params && params.length > 0) {
            msg.append("(");
            if (params.length != paramTypes.length) {
                msg.append(name + ": Wrong number of arguments were passed by " + "the Data Provider: found " + params.length + " but " + "expected " + paramTypes.length + ")");
            } else {
                for (i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        msg.append(", ");
                    }
                    msg.append(Utils.toString(params[i], paramTypes[i]));
                }
                msg.append(")");
            }
        }
        if (!Utils.isStringEmpty(description)) {
            msg.append("\n");
            for (i = 0; i < status.length() + 2; ++i) {
                msg.append(" ");
            }
            msg.append(description);
        }
        if (!Utils.isStringEmpty(stackTrace)) {
            msg.append("\n").append(stackTrace);
        }
        this.logResult(status, msg.toString());
    }

    public void ppp(String s) {
        System.out.println("[TextReporter " + this.getName() + "] " + s);
    }
}

