/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.invocation;

import java.util.Collections;
import org.gradle.api.Transformer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.GradleLauncher;
import org.gradle.internal.Factory;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.work.WorkerLeaseService;

public class GradleBuildController
implements BuildController {
    private State state = State.Created;
    private final GradleLauncher gradleLauncher;
    private final WorkerLeaseService workerLeaseService;

    public GradleBuildController(GradleLauncher gradleLauncher, WorkerLeaseService workerLeaseService) {
        this.gradleLauncher = gradleLauncher;
        this.workerLeaseService = workerLeaseService;
    }

    public GradleBuildController(GradleLauncher gradleLauncher) {
        this(gradleLauncher, gradleLauncher.getGradle().getServices().get(WorkerLeaseService.class));
    }

    public GradleLauncher getLauncher() {
        if (this.state == State.Completed) {
            throw new IllegalStateException("Cannot use launcher after build has completed.");
        }
        return this.gradleLauncher;
    }

    @Override
    public GradleInternal getGradle() {
        return this.getLauncher().getGradle();
    }

    @Override
    public GradleInternal run() {
        return this.doBuild(GradleLauncher::executeTasks);
    }

    @Override
    public GradleInternal configure() {
        return this.doBuild(GradleLauncher::getConfiguredBuild);
    }

    public <T> T doBuild(final Transformer<T, ? super GradleLauncher> build) {
        try {
            Object t = this.workerLeaseService.withLocks(Collections.singleton(this.workerLeaseService.getWorkerLease()), new Factory<T>(){

                @Override
                public T create() {
                    GradleLauncher launcher = GradleBuildController.this.getLauncher();
                    Object result = build.transform(launcher);
                    launcher.finishBuild();
                    return result;
                }
            });
            return t;
        }
        finally {
            this.state = State.Completed;
        }
    }

    @Override
    public void stop() {
        this.gradleLauncher.stop();
    }

    private static enum State {
        Created,
        Completed;

    }
}

