/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.format;

import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.format.LogHeaderFormatter;
import org.gradle.internal.logging.text.StyledTextOutput;

public class PrettyPrefixedLogHeaderFormatter
implements LogHeaderFormatter {
    @Override
    public List<StyledTextOutputEvent.Span> format(String description, String status, boolean failed) {
        if (status.isEmpty()) {
            return Lists.newArrayList(this.header(description, failed), StyledTextOutputEvent.EOL);
        }
        return Lists.newArrayList(this.header(description, failed), this.status(status, failed), StyledTextOutputEvent.EOL);
    }

    private StyledTextOutputEvent.Span header(String message2, boolean failed) {
        StyledTextOutput.Style messageStyle = failed ? StyledTextOutput.Style.FailureHeader : StyledTextOutput.Style.Header;
        return new StyledTextOutputEvent.Span(messageStyle, "> " + message2);
    }

    private StyledTextOutputEvent.Span status(String status, boolean failed) {
        StyledTextOutput.Style statusStyle = failed ? StyledTextOutput.Style.Failure : StyledTextOutput.Style.Info;
        return new StyledTextOutputEvent.Span(statusStyle, " " + status);
    }
}

