/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.notify;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.notify.BuildOperationFinishedNotification;
import org.gradle.internal.operations.notify.BuildOperationNotificationListener;
import org.gradle.internal.operations.notify.BuildOperationNotificationListenerRegistrar;
import org.gradle.internal.operations.notify.BuildOperationNotificationValve;
import org.gradle.internal.operations.notify.BuildOperationProgressNotification;
import org.gradle.internal.operations.notify.BuildOperationStartedNotification;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceScope(value=Scopes.BuildTree.class)
public class BuildOperationNotificationBridge
implements BuildOperationNotificationListenerRegistrar {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildOperationNotificationBridge.class);
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final ListenerManager listenerManager;
    private State state;
    private final BuildOperationNotificationValve valve = new BuildOperationNotificationValve(){

        @Override
        public void start() {
            if (BuildOperationNotificationBridge.this.state != null) {
                throw new IllegalStateException("build operation notification valve already started");
            }
            BuildOperationNotificationBridge.this.state = new State();
            BuildOperationNotificationBridge.this.buildOperationListenerManager.addListener(BuildOperationNotificationBridge.this.state.buildOperationListener);
        }

        @Override
        public void stop() {
            if (BuildOperationNotificationBridge.this.state != null) {
                BuildOperationNotificationBridge.this.state.stop();
                BuildOperationNotificationBridge.this.state = null;
            }
        }
    };
    private final BuildListener buildListener = new InternalBuildAdapter(){

        @Override
        public void beforeSettings(Settings settings) {
            if (settings.getGradle().getParent() == null) {
                settings.getGradle().projectsLoaded((? super Gradle project) -> {
                    State s = BuildOperationNotificationBridge.this.state;
                    if (s != null && s.notificationListener == null) {
                        BuildOperationNotificationBridge.this.valve.stop();
                    }
                });
            }
        }
    };

    public BuildOperationNotificationBridge(BuildOperationListenerManager buildOperationListenerManager, ListenerManager listenerManager) {
        this.buildOperationListenerManager = buildOperationListenerManager;
        this.listenerManager = listenerManager;
        listenerManager.addListener(this.buildListener);
    }

    @Override
    public void register(BuildOperationNotificationListener listener) {
        State state2 = this.requireState();
        state2.assignSingleListener(listener);
        state2.replayAndAttachListener.attach(listener);
    }

    private State requireState() {
        State s = this.state;
        if (s == null) {
            throw new IllegalStateException("state is null");
        }
        return s;
    }

    public BuildOperationNotificationValve getValve() {
        return this.valve;
    }

    private static class Finished
    implements BuildOperationFinishedNotification {
        private final long timestamp;
        private final OperationIdentifier id;
        private final OperationIdentifier parentId;
        private final Object details;
        private final Object result;
        private final Throwable failure;

        private Finished(long timestamp, OperationIdentifier id, OperationIdentifier parentId, Object details, Object result, Throwable failure) {
            this.timestamp = timestamp;
            this.id = id;
            this.parentId = parentId;
            this.details = details;
            this.result = result;
            this.failure = failure;
        }

        @Override
        public long getNotificationOperationFinishedTimestamp() {
            return this.timestamp;
        }

        @Override
        public Object getNotificationOperationId() {
            return this.id;
        }

        @Override
        @Nullable
        public Object getNotificationOperationParentId() {
            return this.parentId;
        }

        @Override
        public Object getNotificationOperationDetails() {
            return this.details;
        }

        @Override
        public Object getNotificationOperationResult() {
            return this.result;
        }

        @Override
        public Throwable getNotificationOperationFailure() {
            return this.failure;
        }

        public String toString() {
            return "BuildOperationFinishedNotification{id=" + this.id + ", parentId=" + this.parentId + ", timestamp=" + this.timestamp + ", details=" + this.details + ", result=" + this.result + ", failure=" + this.failure + '}';
        }
    }

    private static class Progress
    implements BuildOperationProgressNotification {
        private final OperationIdentifier id;
        private final long timestamp;
        private final Object details;

        Progress(OperationIdentifier id, long timestamp, Object details) {
            this.id = id;
            this.timestamp = timestamp;
            this.details = details;
        }

        @Override
        public Object getNotificationOperationId() {
            return this.id;
        }

        @Override
        public long getNotificationOperationProgressTimestamp() {
            return this.timestamp;
        }

        @Override
        public Object getNotificationOperationProgressDetails() {
            return this.details;
        }
    }

    private static class Started
    implements BuildOperationStartedNotification {
        private final long timestamp;
        private final OperationIdentifier id;
        private final OperationIdentifier parentId;
        private final Object details;

        private Started(long timestamp, OperationIdentifier id, OperationIdentifier parentId, Object details) {
            this.timestamp = timestamp;
            this.id = id;
            this.parentId = parentId;
            this.details = details;
        }

        @Override
        public long getNotificationOperationStartedTimestamp() {
            return this.timestamp;
        }

        @Override
        public Object getNotificationOperationId() {
            return this.id;
        }

        @Override
        public Object getNotificationOperationParentId() {
            return this.parentId;
        }

        @Override
        public Object getNotificationOperationDetails() {
            return this.details;
        }

        public String toString() {
            return "BuildOperationStartedNotification{id=" + this.id + ", parentId=" + this.parentId + ", timestamp=" + this.timestamp + ", details=" + this.details + '}';
        }
    }

    private static class ReplayAndAttachListener
    implements BuildOperationNotificationListener {
        private RecordingListener recordingListener = new RecordingListener();
        private volatile BuildOperationNotificationListener listener = this.recordingListener;
        private boolean needLock = true;
        private final Lock lock = new ReentrantLock();

        private ReplayAndAttachListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attach(BuildOperationNotificationListener realListener) {
            this.lock.lock();
            try {
                for (Object storedEvent : this.recordingListener.storedEvents) {
                    if (storedEvent instanceof BuildOperationStartedNotification) {
                        realListener.started((BuildOperationStartedNotification)storedEvent);
                        continue;
                    }
                    if (storedEvent instanceof BuildOperationProgressNotification) {
                        realListener.progress((BuildOperationProgressNotification)storedEvent);
                        continue;
                    }
                    if (!(storedEvent instanceof BuildOperationFinishedNotification)) continue;
                    realListener.finished((BuildOperationFinishedNotification)storedEvent);
                }
                this.listener = realListener;
                this.recordingListener = null;
            }
            finally {
                this.lock.unlock();
                this.needLock = false;
            }
        }

        @Override
        public void started(BuildOperationStartedNotification notification) {
            if (this.needLock) {
                this.lock.lock();
                try {
                    this.listener.started(notification);
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                this.listener.started(notification);
            }
        }

        @Override
        public void progress(BuildOperationProgressNotification notification) {
            if (this.needLock) {
                this.lock.lock();
                try {
                    this.listener.progress(notification);
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                this.listener.progress(notification);
            }
        }

        @Override
        public void finished(BuildOperationFinishedNotification notification) {
            if (this.needLock) {
                this.lock.lock();
                try {
                    this.listener.finished(notification);
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                this.listener.finished(notification);
            }
        }

        public void reset() {
        }
    }

    private static class RecordingListener
    implements BuildOperationNotificationListener {
        private final Queue<Object> storedEvents = new ConcurrentLinkedQueue<Object>();

        private RecordingListener() {
        }

        @Override
        public void started(BuildOperationStartedNotification notification) {
            this.storedEvents.add(notification);
        }

        @Override
        public void progress(BuildOperationProgressNotification notification) {
            this.storedEvents.add(notification);
        }

        @Override
        public void finished(BuildOperationFinishedNotification notification) {
            this.storedEvents.add(notification);
        }
    }

    private static class Adapter
    implements BuildOperationListener {
        private final BuildOperationNotificationListener notificationListener;
        private final Map<OperationIdentifier, OperationIdentifier> parents = new ConcurrentHashMap<OperationIdentifier, OperationIdentifier>();
        private final Map<OperationIdentifier, Object> active = new ConcurrentHashMap<OperationIdentifier, Object>();

        private Adapter(BuildOperationNotificationListener notificationListener) {
            this.notificationListener = notificationListener;
        }

        @Override
        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            OperationIdentifier id = buildOperation.getId();
            OperationIdentifier parentId = buildOperation.getParentId();
            if (parentId != null) {
                if (this.active.containsKey(parentId)) {
                    this.parents.put(id, parentId);
                } else if ((parentId = this.parents.get(parentId)) != null) {
                    this.parents.put(id, parentId);
                }
            }
            if (buildOperation.getDetails() == null) {
                return;
            }
            this.active.put(id, "");
            Started notification = new Started(startEvent.getStartTime(), id, parentId, buildOperation.getDetails());
            try {
                this.notificationListener.started(notification);
            }
            catch (Throwable e) {
                LOGGER.debug("Build operation notification listener threw an error on " + notification, e);
                this.maybeThrow(e);
            }
        }

        private void maybeThrow(Throwable e) {
            if (e instanceof Error && !(e instanceof LinkageError)) {
                throw (Error)e;
            }
        }

        @Override
        public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
            Object details = progressEvent.getDetails();
            if (details == null) {
                return;
            }
            OperationIdentifier owner = this.findOwner(buildOperationId);
            if (owner == null) {
                return;
            }
            this.notificationListener.progress(new Progress(owner, progressEvent.getTime(), details));
        }

        private OperationIdentifier findOwner(OperationIdentifier id) {
            if (this.active.containsKey(id)) {
                return id;
            }
            return this.parents.get(id);
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            OperationIdentifier id = buildOperation.getId();
            OperationIdentifier parentId = this.parents.remove(id);
            if (this.active.remove(id) == null) {
                return;
            }
            Finished notification = new Finished(finishEvent.getEndTime(), id, parentId, buildOperation.getDetails(), finishEvent.getResult(), finishEvent.getFailure());
            try {
                this.notificationListener.finished(notification);
            }
            catch (Throwable e) {
                LOGGER.debug("Build operation notification listener threw an error on " + notification, e);
                this.maybeThrow(e);
            }
        }
    }

    private class State {
        private final ReplayAndAttachListener replayAndAttachListener = new ReplayAndAttachListener();
        private final BuildOperationListener buildOperationListener = new Adapter(this.replayAndAttachListener);
        private BuildOperationNotificationListener notificationListener;

        private State() {
        }

        private void assignSingleListener(BuildOperationNotificationListener notificationListener) {
            if (this.notificationListener != null) {
                throw new IllegalStateException("listener is already registered (implementation class " + this.notificationListener.getClass().getName() + ")");
            }
            this.notificationListener = notificationListener;
        }

        private void stop() {
            BuildOperationNotificationBridge.this.buildOperationListenerManager.removeListener(((BuildOperationNotificationBridge)BuildOperationNotificationBridge.this).state.buildOperationListener);
            BuildOperationNotificationBridge.this.listenerManager.removeListener(BuildOperationNotificationBridge.this.buildListener);
        }
    }
}

