/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.trace.BuildOperationTrace;
import org.gradle.internal.operations.trace.SerializedOperation;

class SerializedOperationFinish
implements SerializedOperation {
    final long id;
    final long endTime;
    final Object result;
    final String resultClassName;
    final String failureMsg;

    SerializedOperationFinish(BuildOperationDescriptor descriptor, OperationFinishEvent finishEvent) {
        this.id = descriptor.getId().getId();
        this.endTime = finishEvent.getEndTime();
        this.result = BuildOperationTrace.toSerializableModel(finishEvent.getResult());
        this.resultClassName = this.result == null ? null : finishEvent.getResult().getClass().getName();
        this.failureMsg = finishEvent.getFailure() == null ? null : finishEvent.getFailure().toString();
    }

    SerializedOperationFinish(Map<String, ?> map) {
        this.id = ((Integer)map.get("id")).longValue();
        this.endTime = (Long)map.get("endTime");
        this.result = map.get("result");
        this.resultClassName = (String)map.get("resultClassName");
        this.failureMsg = (String)map.get("failure");
    }

    @Override
    public Map<String, ?> toMap() {
        ImmutableMap.Builder<String, Object> map = ImmutableMap.builder();
        map.put("id", this.id);
        if (this.result != null) {
            map.put("result", this.result);
            map.put("resultClassName", this.resultClassName);
        }
        if (this.failureMsg != null) {
            map.put("failure", this.failureMsg);
        }
        map.put("endTime", this.endTime);
        return map.build();
    }
}

