/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import javax.annotation.Nullable;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.reflect.ProblemRecordingTypeValidationContext;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;

public class DefaultTypeValidationContext
extends ProblemRecordingTypeValidationContext {
    private final boolean cacheable;
    private final ImmutableMap.Builder<String, Severity> problems = ImmutableMap.builder();

    public static DefaultTypeValidationContext withRootType(DocumentationRegistry documentationRegistry, Class<?> rootType, boolean cacheable) {
        return new DefaultTypeValidationContext(documentationRegistry, rootType, cacheable);
    }

    public static DefaultTypeValidationContext withoutRootType(DocumentationRegistry documentationRegistry, boolean cacheable) {
        return new DefaultTypeValidationContext(documentationRegistry, null, cacheable);
    }

    private DefaultTypeValidationContext(DocumentationRegistry documentationRegistry, @Nullable Class<?> rootType, boolean cacheable) {
        super(documentationRegistry, rootType);
        this.cacheable = cacheable;
    }

    @Override
    protected void recordProblem(TypeValidationProblem problem) {
        boolean cacheableProblemOnly = problem.isCacheabilityProblemOnly();
        if (cacheableProblemOnly && !this.cacheable) {
            return;
        }
        this.problems.put(TypeValidationProblemRenderer.renderMinimalInformationAbout(problem), (Severity)((Object)problem.getSeverity()));
    }

    public ImmutableMap<String, Severity> getProblems() {
        return this.problems.build();
    }
}

