/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class Types {
    private static final Collection<Class<?>> OBJECT_TYPE = ImmutableList.of(Object.class);

    public static <T> void walkTypeHierarchy(Class<T> clazz, TypeVisitor<? extends T> visitor) {
        Types.walkTypeHierarchy(clazz, OBJECT_TYPE, visitor);
    }

    public static <T> void walkTypeHierarchy(Class<T> clazz, Collection<Class<?>> excludedTypes, TypeVisitor<? extends T> visitor) {
        Class type;
        HashSet<Class<?>> seenInterfaces = Sets.newHashSet();
        ArrayDeque<Class> queue = new ArrayDeque<Class>();
        queue.add(clazz);
        while ((type = (Class)queue.poll()) != null) {
            if (excludedTypes.contains(type)) continue;
            visitor.visitType(type);
            Class superclass = type.getSuperclass();
            if (superclass != null) {
                queue.add(superclass);
            }
            for (Class<?> iface : type.getInterfaces()) {
                if (!seenInterfaces.add(iface)) continue;
                queue.add((Class)Cast.uncheckedCast(iface));
            }
        }
    }

    @FunctionalInterface
    public static interface TypeVisitor<T> {
        public void visitType(Class<? super T> var1);
    }
}

