/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import java.util.List;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemLocation;
import org.gradle.model.internal.type.ModelType;
import org.gradle.problems.Solution;

public class TypeValidationProblemRenderer {
    public static String renderMinimalInformationAbout(TypeValidationProblem problem) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem, true);
    }

    public static String renderMinimalInformationAbout(TypeValidationProblem problem, boolean renderDocLink) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem, renderDocLink, true);
    }

    public static String renderMinimalInformationAbout(TypeValidationProblem problem, boolean renderDocLink, boolean renderSolutions) {
        List<Solution> possibleSolutions;
        int solutionCount;
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(TypeValidationProblemRenderer.introductionFor((TypeValidationProblemLocation)problem.getWhere()) + TypeValidationProblemRenderer.maybeAppendDot(problem.getShortDescription()));
        problem.getWhy().ifPresent(reason -> {
            formatter.blankLine();
            formatter.node("Reason: " + StringUtils.capitalize(TypeValidationProblemRenderer.maybeAppendDot(reason)));
        });
        if (renderSolutions && (solutionCount = (possibleSolutions = problem.getPossibleSolutions()).size()) > 0) {
            formatter.blankLine();
            if (solutionCount == 1) {
                formatter.node("Possible solution: " + StringUtils.capitalize(TypeValidationProblemRenderer.maybeAppendDot(possibleSolutions.get(0).getShortDescription())));
            } else {
                formatter.node("Possible solutions");
                formatter.startNumberedChildren();
                possibleSolutions.forEach(solution -> formatter.node(StringUtils.capitalize(TypeValidationProblemRenderer.maybeAppendDot(solution.getShortDescription()))));
                formatter.endChildren();
            }
        }
        if (renderDocLink) {
            problem.getDocumentationLink().ifPresent(docLink -> {
                formatter.blankLine();
                formatter.node("Please refer to ").append((CharSequence)docLink).append(" for more details about this problem.");
            });
        }
        return formatter.toString();
    }

    public static String convertToSingleLine(String message2) {
        return message2.replaceAll("(\\r?\\n)+", ". ").replaceAll("[.]+", ".").replaceAll("[ ]+", " ").replaceAll(": ?[. ]", ": ");
    }

    private static String introductionFor(TypeValidationProblemLocation location) {
        String property;
        StringBuilder builder = new StringBuilder();
        Class rootType = location.getType().orElse(null);
        if (rootType != null) {
            builder.append("Type '");
            builder.append(ModelType.of(rootType).getDisplayName());
            builder.append("' ");
        }
        if ((property = (String)location.getPropertyName().orElse(null)) != null) {
            if (rootType == null) {
                builder.append("Property '");
            } else {
                builder.append("property '");
            }
            location.getParentPropertyName().ifPresent(parentProperty -> {
                builder.append((String)parentProperty);
                builder.append('.');
            });
            builder.append(property);
            builder.append("' ");
        }
        return builder.toString();
    }

    private static String maybeAppendDot(String txt) {
        if (txt.endsWith(".") || txt.endsWith("\n")) {
            return txt;
        }
        return txt + ".";
    }
}

