/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.impldep.com.google.common.io.CountingInputStream;
import org.gradle.internal.resource.AbstractExternalResource;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceReadResult;
import org.gradle.internal.resource.ExternalResourceWriteResult;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;

public class AccessorBackedExternalResource
extends AbstractExternalResource {
    private final ExternalResourceName name;
    private final ExternalResourceAccessor accessor;
    private final ExternalResourceUploader uploader;
    private final ExternalResourceLister lister;
    private final boolean revalidate;

    public AccessorBackedExternalResource(ExternalResourceName name, ExternalResourceAccessor accessor, ExternalResourceUploader uploader, ExternalResourceLister lister, boolean revalidate) {
        this.name = name;
        this.accessor = accessor;
        this.uploader = uploader;
        this.lister = lister;
        this.revalidate = revalidate;
    }

    @Override
    public URI getURI() {
        return this.name.getUri();
    }

    @Override
    public String getDisplayName() {
        return this.name.getDisplayName();
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public ExternalResourceReadResult<Void> writeToIfPresent(File destination) throws ResourceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ExternalResourceReadResult<Void> writeTo(OutputStream destination) throws ResourceException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> ExternalResourceReadResult<T> withContentIfPresent(Transformer<? extends T, ? super InputStream> transformer) throws ResourceException {
        try {
            ExternalResourceReadResponse response = this.accessor.openResource(this.name.getUri(), this.revalidate);
            if (response == null) {
                return null;
            }
            try {
                ExternalResourceReadResult<T> externalResourceReadResult;
                CountingInputStream input = new CountingInputStream(new BufferedInputStream(response.openStream()));
                try {
                    T value = transformer.transform(input);
                    externalResourceReadResult = ExternalResourceReadResult.of(input.getCount(), value);
                }
                catch (Throwable throwable) {
                    input.close();
                    throw throwable;
                }
                input.close();
                return externalResourceReadResult;
            }
            finally {
                response.close();
            }
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(this.name.getUri(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> ExternalResourceReadResult<T> withContentIfPresent(ExternalResource.ContentAction<? extends T> readAction) throws ResourceException {
        try {
            ExternalResourceReadResponse response = this.accessor.openResource(this.name.getUri(), this.revalidate);
            if (response == null) {
                return null;
            }
            try {
                ExternalResourceReadResult<T> externalResourceReadResult;
                CountingInputStream stream = new CountingInputStream(new BufferedInputStream(response.openStream()));
                try {
                    T value = readAction.execute(stream, response.getMetaData());
                    externalResourceReadResult = ExternalResourceReadResult.of(stream.getCount(), value);
                }
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return externalResourceReadResult;
            }
            finally {
                response.close();
            }
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(this.name.getUri(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalResourceReadResult<Void> withContent(Action<? super InputStream> readAction) throws ResourceException {
        ExternalResourceReadResult<Void> externalResourceReadResult;
        ExternalResourceReadResponse response = this.accessor.openResource(this.name.getUri(), this.revalidate);
        if (response == null) {
            throw ResourceExceptions.getMissing(this.getURI());
        }
        try {
            CountingInputStream inputStream = new CountingInputStream(response.openStream());
            readAction.execute(inputStream);
            externalResourceReadResult = ExternalResourceReadResult.of(inputStream.getCount());
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (IOException e) {
                throw ResourceExceptions.getFailed(this.name.getUri(), e);
            }
        }
        response.close();
        return externalResourceReadResult;
    }

    @Override
    public <T> ExternalResourceReadResult<T> withContent(ExternalResource.ContentAction<? extends T> readAction) throws ResourceException {
        ExternalResourceReadResult<? extends T> result = this.withContentIfPresent(readAction);
        if (result == null) {
            throw ResourceExceptions.getMissing(this.getURI());
        }
        return result;
    }

    @Override
    public ExternalResourceWriteResult put(ReadableContent source) throws ResourceException {
        try {
            CountingReadableContent countingResource = new CountingReadableContent(source);
            this.uploader.upload(countingResource, this.getURI());
            return new ExternalResourceWriteResult(countingResource.getCount());
        }
        catch (IOException e) {
            throw ResourceExceptions.putFailed(this.getURI(), e);
        }
    }

    @Override
    @Nullable
    public List<String> list() throws ResourceException {
        try {
            return this.lister.list(this.getURI());
        }
        catch (Exception e) {
            throw ResourceExceptions.getFailed(this.getURI(), e);
        }
    }

    @Override
    public ExternalResourceMetaData getMetaData() {
        return this.accessor.getMetaData(this.getURI(), this.revalidate);
    }

    private static class CountingReadableContent
    implements ReadableContent {
        private final ReadableContent source;
        private CountingInputStream instr;
        private long count;

        CountingReadableContent(ReadableContent source) {
            this.source = source;
        }

        @Override
        public InputStream open() throws ResourceException {
            if (this.instr != null) {
                this.count += this.instr.getCount();
            }
            this.instr = new CountingInputStream(this.source.open());
            return this.instr;
        }

        @Override
        public long getContentLength() {
            return this.source.getContentLength();
        }

        public long getCount() {
            return this.instr != null ? this.count + this.instr.getCount() : this.count;
        }
    }
}

