/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ObjectListing;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.S3ObjectSummary;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Predicates;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;

public class S3ResourceResolver {
    private static final Pattern FILENAME_PATTERN = Pattern.compile("[^/]+\\.*$");
    private static final Function<S3ObjectSummary, String> EXTRACT_FILE_NAME = new Function<S3ObjectSummary, String>(){

        @Override
        public String apply(S3ObjectSummary input) {
            Matcher matcher = FILENAME_PATTERN.matcher(input.getKey());
            if (matcher.find()) {
                String group = matcher.group(0);
                return group.contains(".") ? group : null;
            }
            return null;
        }
    };

    public List<String> resolveResourceNames(ObjectListing objectListing) {
        ArrayList<String> results = new ArrayList<String>();
        results.addAll(this.resolveFileResourceNames(objectListing));
        results.addAll(this.resolveDirectoryResourceNames(objectListing));
        return results;
    }

    private List<String> resolveFileResourceNames(ObjectListing objectListing) {
        List<S3ObjectSummary> objectSummaries = objectListing.getObjectSummaries();
        if (null != objectSummaries) {
            return ImmutableList.copyOf(Iterables.filter(Iterables.transform(objectSummaries, EXTRACT_FILE_NAME), Predicates.notNull()));
        }
        return Collections.emptyList();
    }

    private List<String> resolveDirectoryResourceNames(ObjectListing objectListing) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (objectListing.getCommonPrefixes() != null) {
            for (String prefix : objectListing.getCommonPrefixes()) {
                String directChild = prefix.split(Pattern.quote(objectListing.getPrefix()))[1];
                if (directChild.endsWith("/")) {
                    builder.add(directChild.substring(0, directChild.length() - 1));
                    continue;
                }
                builder.add(directChild);
            }
            return builder.build();
        }
        return Collections.emptyList();
    }
}

