/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.gcp.gcs;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.api.client.auth.oauth2.Credential;
import org.gradle.internal.impldep.com.google.api.client.http.HttpBackOffIOExceptionHandler;
import org.gradle.internal.impldep.com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import org.gradle.internal.impldep.com.google.api.client.http.HttpRequest;
import org.gradle.internal.impldep.com.google.api.client.http.HttpRequestInitializer;
import org.gradle.internal.impldep.com.google.api.client.http.HttpResponse;
import org.gradle.internal.impldep.com.google.api.client.http.HttpTransport;
import org.gradle.internal.impldep.com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import org.gradle.internal.impldep.com.google.api.client.util.ExponentialBackOff;
import org.gradle.internal.impldep.com.google.api.client.util.Sleeper;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.base.Supplier;

final class RetryHttpInitializerWrapper
implements HttpRequestInitializer {
    private static final org.gradle.api.logging.Logger LOG = Logging.getLogger(RetryHttpInitializerWrapper.class);
    private static final long DEFAULT_READ_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(2L);
    private final Supplier<Credential> credentialSupplier;
    private final Sleeper sleeper;

    RetryHttpInitializerWrapper(Supplier<Credential> credentialSupplier) {
        this(credentialSupplier, Sleeper.DEFAULT);
    }

    RetryHttpInitializerWrapper(Supplier<Credential> credentialSupplier, Sleeper sleeper) {
        this.credentialSupplier = Preconditions.checkNotNull(credentialSupplier);
        this.sleeper = sleeper;
    }

    @Override
    public void initialize(HttpRequest request) {
        boolean loggingEnabled = false;
        request.setLoggingEnabled(false);
        request.setCurlLoggingEnabled(false);
        RetryHttpInitializerWrapper.disableHttpTransportLogging();
        request.setReadTimeout((int)DEFAULT_READ_TIMEOUT_MILLIS);
        final HttpBackOffUnsuccessfulResponseHandler backoffHandler = new HttpBackOffUnsuccessfulResponseHandler(new ExponentialBackOff()).setSleeper(this.sleeper);
        final Credential credential = this.credentialSupplier.get();
        request.setInterceptor(credential);
        request.setUnsuccessfulResponseHandler(new HttpUnsuccessfulResponseHandler(){

            @Override
            public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
                request.setLoggingEnabled(false);
                request.setCurlLoggingEnabled(false);
                if (credential.handleResponse(request, response, supportsRetry)) {
                    return true;
                }
                if (backoffHandler.handleResponse(request, response, supportsRetry)) {
                    LOG.info("Retrying {}", (Object)request.getUrl());
                    return true;
                }
                return false;
            }
        });
        request.setIOExceptionHandler(new HttpBackOffIOExceptionHandler(new ExponentialBackOff()).setSleeper(this.sleeper));
    }

    private static void disableHttpTransportLogging() {
        Logger.getLogger(HttpTransport.class.getName()).setLevel(Level.OFF);
    }
}

