/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.net.URI;
import org.gradle.internal.impldep.org.apache.http.HttpEntityEnclosingRequest;
import org.gradle.internal.impldep.org.apache.http.HttpRequest;
import org.gradle.internal.impldep.org.apache.http.HttpResponse;
import org.gradle.internal.impldep.org.apache.http.ProtocolException;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpDelete;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpGet;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpHead;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpOptions;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpPatch;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpPost;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpPut;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpTrace;
import org.gradle.internal.impldep.org.apache.http.client.methods.HttpUriRequest;
import org.gradle.internal.impldep.org.apache.http.impl.client.DefaultRedirectStrategy;
import org.gradle.internal.impldep.org.apache.http.protocol.HttpContext;

public class AlwaysRedirectRedirectStrategy
extends DefaultRedirectStrategy {
    @Override
    protected boolean isRedirectable(String method) {
        return true;
    }

    @Override
    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        URI uri = this.getLocationURI(request, response, context);
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("HEAD")) {
            return new HttpHead(uri);
        }
        if (method.equalsIgnoreCase("POST")) {
            return this.copyEntity(new HttpPost(uri), request);
        }
        if (method.equalsIgnoreCase("PUT")) {
            return this.copyEntity(new HttpPut(uri), request);
        }
        if (method.equalsIgnoreCase("DELETE")) {
            return new HttpDelete(uri);
        }
        if (method.equalsIgnoreCase("TRACE")) {
            return new HttpTrace(uri);
        }
        if (method.equalsIgnoreCase("OPTIONS")) {
            return new HttpOptions(uri);
        }
        if (method.equalsIgnoreCase("PATCH")) {
            return this.copyEntity(new HttpPatch(uri), request);
        }
        return new HttpGet(uri);
    }

    private HttpUriRequest copyEntity(HttpEntityEnclosingRequestBase redirect, HttpRequest original) {
        if (original instanceof HttpEntityEnclosingRequest) {
            redirect.setEntity(((HttpEntityEnclosingRequest)original).getEntity());
        }
        return redirect;
    }
}

