/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.impldep.org.apache.http.entity.AbstractHttpEntity;
import org.gradle.internal.impldep.org.apache.http.entity.ContentType;
import org.gradle.internal.resource.ReadableContent;

public class RepeatableInputStreamEntity
extends AbstractHttpEntity {
    private final ReadableContent source;

    public RepeatableInputStreamEntity(ReadableContent source, ContentType contentType) {
        this.source = source;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.source.getContentLength();
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        return this.source.open();
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        InputStream content = this.getContent();
        try {
            IOUtils.copyLarge(content, outstream);
        }
        finally {
            IoActions.closeQuietly(content);
        }
    }

    @Override
    public boolean isStreaming() {
        return true;
    }
}

