/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scripts;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.FileUtils;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.internal.scripts.ScriptingLanguages;
import org.gradle.scripts.ScriptingLanguage;

public class DefaultScriptFileResolver
implements ScriptFileResolver {
    private static final String[] EXTENSIONS = DefaultScriptFileResolver.scriptingLanguageExtensions();

    @Override
    public File resolveScriptFile(File dir2, String basename) {
        for (String extension : EXTENSIONS) {
            File candidate = new File(dir2, basename + extension);
            if (!candidate.isFile()) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public List<File> findScriptsIn(File dir2) {
        File[] candidates = dir2.listFiles();
        if (candidates == null || candidates.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> found = new ArrayList<File>(candidates.length);
        for (File candidate : candidates) {
            if (!candidate.isFile() || !this.hasScriptExtension(candidate)) continue;
            found.add(candidate);
        }
        return found;
    }

    private boolean hasScriptExtension(File file) {
        for (String extension : EXTENSIONS) {
            if (!FileUtils.hasExtension(file, extension)) continue;
            return true;
        }
        return false;
    }

    private static String[] scriptingLanguageExtensions() {
        List<ScriptingLanguage> scriptingLanguages = ScriptingLanguages.all();
        String[] extensions = new String[scriptingLanguages.size()];
        for (int i = 0; i < extensions.length; ++i) {
            extensions[i] = scriptingLanguages.get(i).getExtension();
        }
        return extensions;
    }
}

