/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.EOFException;
import java.util.Collection;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public abstract class AbstractCollectionSerializer<T, C extends Collection<T>>
implements Serializer<C> {
    protected final Serializer<T> entrySerializer;

    public AbstractCollectionSerializer(Serializer<T> entrySerializer) {
        this.entrySerializer = entrySerializer;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractCollectionSerializer rhs = (AbstractCollectionSerializer)obj;
        return Objects.equal(this.entrySerializer, rhs.entrySerializer);
    }

    public int hashCode() {
        return Objects.hashCode(this.getClass(), this.entrySerializer);
    }

    protected abstract C createCollection(int var1);

    @Override
    public C read(Decoder decoder) throws EOFException, Exception {
        int size = decoder.readInt();
        C values = this.createCollection(size);
        for (int i = 0; i < size; ++i) {
            values.add(this.entrySerializer.read(decoder));
        }
        return values;
    }

    @Override
    public void write(Encoder encoder, C value) throws Exception {
        encoder.writeInt(value.size());
        for (Object t : value) {
            this.entrySerializer.write(encoder, t);
        }
    }
}

