/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.util.Collections;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.serialize.AbstractCollectionSerializer;
import org.gradle.internal.serialize.Serializer;

public class SetSerializer<T>
extends AbstractCollectionSerializer<T, Set<T>>
implements Serializer<Set<T>> {
    private final boolean linkedHashSet;

    public SetSerializer(Serializer<T> entrySerializer) {
        this(entrySerializer, true);
    }

    public SetSerializer(Serializer<T> entrySerializer, boolean linkedHashSet) {
        super(entrySerializer);
        this.linkedHashSet = linkedHashSet;
    }

    @Override
    protected Set<T> createCollection(int size) {
        if (size == 0) {
            return Collections.emptySet();
        }
        return this.linkedHashSet ? Sets.newLinkedHashSetWithExpectedSize(size) : Sets.newHashSetWithExpectedSize(size);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SetSerializer rhs = (SetSerializer)obj;
        return this.linkedHashSet == rhs.linkedHashSet;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.linkedHashSet);
    }
}

