/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.kryo;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.KryoException;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.Input;
import org.gradle.internal.serialize.AbstractDecoder;
import org.gradle.internal.serialize.Decoder;

public class KryoBackedDecoder
extends AbstractDecoder
implements Decoder,
Closeable {
    private final Input input;
    private final InputStream inputStream;
    private long extraSkipped;
    private KryoBackedDecoder nested;

    public KryoBackedDecoder(InputStream inputStream) {
        this(inputStream, 4096);
    }

    public KryoBackedDecoder(InputStream inputStream, int bufferSize) {
        this.inputStream = inputStream;
        this.input = new Input(this.inputStream, bufferSize);
    }

    @Override
    protected int maybeReadBytes(byte[] buffer, int offset, int count) {
        return this.input.read(buffer, offset, count);
    }

    @Override
    protected long maybeSkip(long count) throws IOException {
        int remaining = this.input.limit() - this.input.position();
        if (remaining == 0) {
            long skipped = this.inputStream.skip(count);
            if (skipped > 0L) {
                this.extraSkipped += skipped;
            }
            return skipped;
        }
        if (count <= (long)remaining) {
            this.input.setPosition(this.input.position() + (int)count);
            return count;
        }
        this.input.setPosition(this.input.limit());
        return remaining;
    }

    private RuntimeException maybeEndOfStream(KryoException e) throws EOFException {
        if (e.getMessage().equals("Buffer underflow.")) {
            throw (EOFException)new EOFException().initCause(e);
        }
        throw e;
    }

    @Override
    public byte readByte() throws EOFException {
        try {
            return this.input.readByte();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public void readBytes(byte[] buffer, int offset, int count) throws EOFException {
        try {
            this.input.readBytes(buffer, offset, count);
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public long readLong() throws EOFException {
        try {
            return this.input.readLong();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public long readSmallLong() throws EOFException, IOException {
        try {
            return this.input.readLong(true);
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public int readInt() throws EOFException {
        try {
            return this.input.readInt();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public int readSmallInt() throws EOFException {
        try {
            return this.input.readInt(true);
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public boolean readBoolean() throws EOFException {
        try {
            return this.input.readBoolean();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public String readString() throws EOFException {
        return this.readNullableString();
    }

    @Override
    public String readNullableString() throws EOFException {
        try {
            return this.input.readString();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    @Override
    public void skipChunked() throws EOFException, IOException {
        int count;
        while ((count = this.readSmallInt()) != 0) {
            this.skipBytes(count);
        }
    }

    @Override
    public <T> T decodeChunked(Decoder.DecodeAction<Decoder, T> decodeAction) throws EOFException, Exception {
        if (this.nested == null) {
            this.nested = new KryoBackedDecoder(new InputStream(){

                @Override
                public int read() throws IOException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int read(byte[] buffer, int offset, int length) throws IOException {
                    int count = KryoBackedDecoder.this.readSmallInt();
                    if (count == 0) {
                        return -1;
                    }
                    if (count > length) {
                        throw new UnsupportedOperationException();
                    }
                    KryoBackedDecoder.this.readBytes(buffer, offset, count);
                    return count;
                }
            });
        }
        T value = decodeAction.read(this.nested);
        if (this.readSmallInt() != 0) {
            throw new IllegalStateException("Expecting the end of nested stream.");
        }
        return value;
    }

    public long getReadPosition() {
        return this.input.total() + this.extraSkipped;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

