/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.task;

import java.util.List;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.jvm.toolchain.internal.task.ReportableToolchain;

public class ToolchainReportRenderer
extends TextReportRenderer {
    public void printToolchain(ReportableToolchain toolchain) {
        StyledTextOutput output = this.getTextOutput();
        JvmInstallationMetadata metadata = toolchain.metadata;
        String displayName = metadata.getDisplayName();
        output.withStyle(StyledTextOutput.Style.Identifier).println(" + " + displayName + " " + metadata.getImplementationVersion());
        this.printAttribute("Location", metadata.getJavaHome().toString());
        this.printAttribute("Language Version", metadata.getLanguageVersion().getMajorVersion());
        this.printAttribute("Vendor", metadata.getVendor().getDisplayName());
        this.printAttribute("Is JDK", String.valueOf(metadata.hasCapability(JvmInstallationMetadata.JavaInstallationCapability.JAVA_COMPILER)));
        this.printAttribute("Detected by", toolchain.location.getSource());
        output.println();
    }

    private void printAttribute(String key, String value) {
        String paddedKey = Strings.padEnd(key + ":", 20, ' ');
        this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).format("     | %s", paddedKey);
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).println(value);
    }

    public void printInvalidToolchains(List<ReportableToolchain> invalidToolchains) {
        if (!invalidToolchains.isEmpty()) {
            StyledTextOutput output = this.getTextOutput();
            output.withStyle(StyledTextOutput.Style.Identifier).println(" + Invalid toolchains");
            for (ReportableToolchain toolchain : invalidToolchains) {
                JvmInstallationMetadata metadata = toolchain.metadata;
                output.withStyle(StyledTextOutput.Style.Identifier).println("     + " + metadata.getJavaHome());
                String paddedErrorType = Strings.padEnd("Error:", 20, ' ');
                this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).format("       | %s", paddedErrorType);
                this.getTextOutput().withStyle(StyledTextOutput.Style.Description).println(metadata.getErrorMessage());
            }
            output.println();
        }
    }
}

