/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.plugins;

import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class CleanRule
implements Rule {
    public static final String CLEAN = "clean";
    private final TaskContainer tasks;

    public CleanRule(TaskContainer tasks) {
        this.tasks = tasks;
    }

    @Override
    public String getDescription() {
        return "Pattern: clean<TaskName>: Cleans the output files of a task.";
    }

    public String toString() {
        return "Rule: " + this.getDescription();
    }

    @Override
    public void apply(String taskName) {
        if (!taskName.startsWith(CLEAN) || taskName.equals(CLEAN)) {
            return;
        }
        String targetTaskName = taskName.substring(CLEAN.length());
        if (Character.isLowerCase(targetTaskName.charAt(0))) {
            return;
        }
        Task task = (Task)this.tasks.findByName(StringUtils.uncapitalize(targetTaskName));
        if (task == null) {
            return;
        }
        Delete clean = (Delete)this.tasks.create(taskName, Delete.class);
        clean.delete(task.getOutputs().getFiles());
    }
}

