/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.plugins.internal.AbstractUsageContext;
import org.gradle.internal.Cast;

public class DefaultUsageContext
extends AbstractUsageContext
implements Named {
    private final String name;
    private final Set<? extends ModuleDependency> dependencies;
    private final Set<? extends DependencyConstraint> dependencyConstraints;
    private final Set<ExcludeRule> globalExcludes;

    public DefaultUsageContext(UsageContext usageContext, Set<? extends PublishArtifact> artifacts2, Configuration configuration) {
        this(usageContext.getName(), usageContext.getAttributes(), artifacts2, configuration);
    }

    public DefaultUsageContext(String name, AttributeContainer attributes) {
        this(name, attributes, null, null);
    }

    public DefaultUsageContext(String name, AttributeContainer attributes, Set<? extends PublishArtifact> artifacts2, Configuration configuration) {
        super(((AttributeContainerInternal)attributes).asImmutable(), (Set)Cast.uncheckedCast(artifacts2));
        this.name = name;
        if (configuration != null) {
            this.dependencies = configuration.getAllDependencies().withType(ModuleDependency.class);
            this.dependencyConstraints = configuration.getAllDependencyConstraints();
            this.globalExcludes = ((ConfigurationInternal)configuration).getAllExcludeRules();
        } else {
            this.dependencies = null;
            this.dependencyConstraints = null;
            this.globalExcludes = Collections.emptySet();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<? extends ModuleDependency> getDependencies() {
        assert (this.dependencies != null);
        return this.dependencies;
    }

    @Override
    public Set<? extends DependencyConstraint> getDependencyConstraints() {
        assert (this.dependencyConstraints != null);
        return this.dependencyConstraints;
    }

    @Override
    public Set<? extends Capability> getCapabilities() {
        return Collections.emptySet();
    }

    @Override
    public Set<ExcludeRule> getGlobalExcludes() {
        return this.globalExcludes;
    }
}

