/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.collect.LinkedHashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.language.nativeplatform.internal.Expression;

class TokenLookup {
    private Set<Expression> broken;
    private Multimap<Expression, Expression> tokensFor;

    TokenLookup() {
    }

    boolean isUnresolved(Expression expression) {
        return this.broken != null && this.broken.contains(expression);
    }

    void unresolved(Expression expression) {
        if (this.broken == null) {
            this.broken = new HashSet<Expression>();
        }
        this.broken.add(expression);
    }

    Collection<Expression> tokensFor(Expression expression) {
        if (this.tokensFor == null) {
            return Collections.emptyList();
        }
        return this.tokensFor.get(expression);
    }

    void addTokensFor(Expression expression, Expression tokens) {
        if (this.tokensFor == null) {
            this.tokensFor = LinkedHashMultimap.create();
        }
        this.tokensFor.put(expression, tokens);
    }

    boolean hasTokensFor(Expression expression) {
        return this.tokensFor != null && this.tokensFor.containsKey(expression);
    }
}

