/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.util.ArrayList;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DaemonStartupMessage {
    public static final String STARTING_DAEMON_MESSAGE = "Starting a Gradle Daemon";
    public static final String SUBSEQUENT_BUILDS_WILL_BE_FASTER = "(subsequent builds will be faster)";
    public static final String NOT_REUSED_MESSAGE = " could not be reused, use --status for details";

    public static String generate(int numBusy, int numIncompatible, int numStopped) {
        int totalUnavailableDaemons = numBusy + numIncompatible + numStopped;
        if (totalUnavailableDaemons > 0) {
            ArrayList<String> reasons = Lists.newArrayList();
            if (numBusy > 0) {
                reasons.add(numBusy + " busy");
            }
            if (numIncompatible > 0) {
                reasons.add(numIncompatible + " incompatible");
            }
            if (numStopped > 0) {
                reasons.add(numStopped + " stopped");
            }
            return "Starting a Gradle Daemon, " + Joiner.on(" and ").join(reasons) + " Daemon" + (totalUnavailableDaemons > 1 ? "s" : "") + NOT_REUSED_MESSAGE;
        }
        return "Starting a Gradle Daemon (subsequent builds will be faster)";
    }
}

