/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.expiry;

import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;

public class AnyDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private Iterable<DaemonExpirationStrategy> expirationStrategies;

    public AnyDaemonExpirationStrategy(List<DaemonExpirationStrategy> expirationStrategies) {
        this.expirationStrategies = expirationStrategies;
    }

    @Override
    public DaemonExpirationResult checkExpiration() {
        DaemonExpirationStatus expirationStatus = DaemonExpirationStatus.DO_NOT_EXPIRE;
        ArrayList<String> reasons = Lists.newArrayList();
        for (DaemonExpirationStrategy expirationStrategy : this.expirationStrategies) {
            DaemonExpirationResult expirationResult = expirationStrategy.checkExpiration();
            if (expirationResult.getStatus() == DaemonExpirationStatus.DO_NOT_EXPIRE) continue;
            reasons.add(expirationResult.getReason());
            expirationStatus = DaemonExpirationStatus.highestPriorityOf(expirationResult.getStatus(), expirationStatus);
        }
        if (expirationStatus == DaemonExpirationStatus.DO_NOT_EXPIRE) {
            return DaemonExpirationResult.NOT_TRIGGERED;
        }
        return new DaemonExpirationResult(expirationStatus, Joiner.on(" and ").skipNulls().join(reasons));
    }
}

