/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health.gc;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.launcher.daemon.server.health.gc.SlidingWindow;

public class DefaultSlidingWindow<T>
implements SlidingWindow<T> {
    final LinkedBlockingDeque<T> deque;
    final ReentrantLock lock = new ReentrantLock();

    public DefaultSlidingWindow(int capacity) {
        this.deque = new LinkedBlockingDeque(capacity);
    }

    @Override
    public void slideAndInsert(T element) {
        this.lock.lock();
        try {
            while (!this.deque.offerLast(element)) {
                this.deque.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Collection<T> snapshot() {
        this.lock.lock();
        try {
            LinkedHashSet<T> linkedHashSet = Sets.newLinkedHashSet(this.deque);
            return linkedHashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T latest() {
        this.lock.lock();
        try {
            T t = this.deque.peekLast();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

