/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.base.Predicates;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.type.ModelType;

public class ModelNodes {
    public static Predicate<MutableModelNode> all() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<MutableModelNode> withType(Class<?> type) {
        return ModelNodes.withType(ModelType.of(type));
    }

    public static Predicate<MutableModelNode> withType(ModelType<?> type) {
        return ModelNodes.withType(type, Predicates.alwaysTrue());
    }

    public static Predicate<MutableModelNode> withType(Class<?> type, Predicate<? super MutableModelNode> predicate) {
        return ModelNodes.withType(ModelType.of(type), predicate);
    }

    public static Predicate<MutableModelNode> withType(final ModelType<?> type, final Predicate<? super MutableModelNode> predicate) {
        return new Predicate<MutableModelNode>(){

            @Override
            public boolean apply(MutableModelNode node) {
                node.ensureAtLeast(ModelNode.State.Discovered);
                return node.canBeViewedAs(type) && predicate.apply(node);
            }
        };
    }
}

