/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import org.gradle.internal.BiAction;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.model.ModelSet;
import org.gradle.model.internal.core.AddProjectionsAction;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.DefaultModelViewState;
import org.gradle.model.internal.core.DirectNodeInputUsingModelAction;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViewFactory;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeBackedModelSet;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.TypedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ManagedChildNodeCreatorStrategy;
import org.gradle.model.internal.manage.schema.CollectionSchema;
import org.gradle.model.internal.manage.schema.extract.CollectionNodeInitializerExtractionSupport;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;

public class ModelSetNodeInitializerExtractionStrategy
extends CollectionNodeInitializerExtractionSupport {
    private static final ModelType<ModelSet<?>> MODEL_SET_MODEL_TYPE = new ModelType<ModelSet<?>>(){};

    @Override
    protected <T, E> NodeInitializer extractNodeInitializer(CollectionSchema<T, E> schema, NodeInitializerContext<T> context) {
        if (MODEL_SET_MODEL_TYPE.isAssignableFrom(schema.getType())) {
            return new ModelSetNodeInitializer<T, E>(schema);
        }
        return null;
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableList.of(MODEL_SET_MODEL_TYPE);
    }

    private static class ModelSetNodeInitializer<T, E>
    implements NodeInitializer {
        private final CollectionSchema<T, E> schema;

        public ModelSetNodeInitializer(CollectionSchema<T, E> schema) {
            this.schema = schema;
        }

        @Override
        public Multimap<ModelActionRole, ModelAction> getActions(ModelReference<?> subject, ModelRuleDescriptor descriptor) {
            return ((ImmutableSetMultimap.Builder)((ImmutableSetMultimap.Builder)ImmutableSetMultimap.builder().put((Object)ModelActionRole.Discover, AddProjectionsAction.of(subject, descriptor, TypedModelProjection.of(ModelTypes.modelSet(this.schema.getElementType()), new ModelSetModelViewFactory<E>(this.schema.getElementType()))))).put((Object)ModelActionRole.Create, DirectNodeInputUsingModelAction.of(subject, descriptor, ModelReference.of(NodeInitializerRegistry.class), new BiAction<MutableModelNode, NodeInitializerRegistry>(){

                @Override
                public void execute(MutableModelNode modelNode, NodeInitializerRegistry nodeInitializerRegistry) {
                    ManagedChildNodeCreatorStrategy childStrategy = new ManagedChildNodeCreatorStrategy(nodeInitializerRegistry);
                    modelNode.setPrivateData(ChildNodeInitializerStrategy.class, childStrategy);
                }
            }))).build();
        }
    }

    private static class ModelSetModelViewFactory<T>
    implements ModelViewFactory<ModelSet<T>> {
        private final ModelType<T> elementType;

        public ModelSetModelViewFactory(ModelType<T> elementType) {
            this.elementType = elementType;
        }

        @Override
        public ModelView<ModelSet<T>> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean mutable) {
            ModelType<ModelSet<T>> setType = ModelTypes.modelSet(this.elementType);
            DefaultModelViewState state2 = new DefaultModelViewState(modelNode.getPath(), setType, ruleDescriptor, mutable, !mutable);
            ChildNodeInitializerStrategy childStrategy = (ChildNodeInitializerStrategy)Cast.uncheckedCast(modelNode.getPrivateData(ChildNodeInitializerStrategy.class));
            NodeBackedModelSet<T> set2 = new NodeBackedModelSet<T>(setType, this.elementType, ruleDescriptor, modelNode, state2, childStrategy);
            return InstanceModelView.of(modelNode.getPath(), setType, set2, state2.closer());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelSetModelViewFactory that = (ModelSetModelViewFactory)o;
            return this.elementType.equals(that.elementType);
        }

        public int hashCode() {
            return this.elementType.hashCode();
        }
    }
}

